/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.sizeof;

import com.alibaba.otter.shared.common.utils.sizeof.Integers;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ObjectProfiler {
    public static final int OBJECT_SHELL_SIZE = 8;
    public static final int OBJREF_SIZE = 4;
    public static final int LONG_FIELD_SIZE = 8;
    public static final int INT_FIELD_SIZE = 4;
    public static final int SHORT_FIELD_SIZE = 2;
    public static final int CHAR_FIELD_SIZE = 2;
    public static final int BYTE_FIELD_SIZE = 1;
    public static final int BOOLEAN_FIELD_SIZE = 1;
    public static final int DOUBLE_FIELD_SIZE = 8;
    public static final int FLOAT_FIELD_SIZE = 4;
    private static final Map CLASS_METADATA_CACHE = new WeakHashMap(101);
    static final Class[] sunProblematicClasses;
    static final Map sunProblematicClassesSizes;

    public static long sizeof(Object obj) {
        if (null == obj || ObjectProfiler.isSharedFlyweight(obj)) {
            return 0L;
        }
        IdentityHashMap visited = new IdentityHashMap(80000);
        try {
            return ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
        }
        catch (RuntimeException re) {
            return -1L;
        }
        catch (NoClassDefFoundError ncdfe) {
            return -1L;
        }
    }

    public static long sizedelta(Object base, Object obj) {
        if (null == obj || ObjectProfiler.isSharedFlyweight(obj)) {
            return 0L;
        }
        if (null == base) {
            throw new IllegalArgumentException("null input: base");
        }
        IdentityHashMap visited = new IdentityHashMap(40000);
        try {
            ObjectProfiler.computeSizeof(base, visited, CLASS_METADATA_CACHE);
            return visited.containsKey(obj) ? 0L : ObjectProfiler.computeSizeof(obj, visited, CLASS_METADATA_CACHE);
        }
        catch (RuntimeException re) {
            return -1L;
        }
        catch (NoClassDefFoundError ncdfe) {
            return -1L;
        }
    }

    private ObjectProfiler() {
    }

    private static long computeSizeof(Object obj, IdentityHashMap visited, Map metadataMap) {
        if (null == obj || ObjectProfiler.isSharedFlyweight(obj)) {
            return 0L;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.put(obj, obj);
        queue.add(obj);
        long result = 0L;
        ClassAccessPrivilegedAction caAction = new ClassAccessPrivilegedAction();
        FieldAccessPrivilegedAction faAction = new FieldAccessPrivilegedAction();
        while (!queue.isEmpty()) {
            obj = queue.removeFirst();
            Class<?> objClass = obj.getClass();
            int skippedBytes = ObjectProfiler.skipClassDueToSunJVMBug(objClass);
            if (skippedBytes > 0) {
                result += (long)skippedBytes;
                continue;
            }
            if (objClass.isArray()) {
                int arrayLength = Array.getLength(obj);
                Class<?> componentType = objClass.getComponentType();
                result += (long)ObjectProfiler.sizeofArrayShell(arrayLength, componentType);
                if (componentType.isPrimitive()) continue;
                for (int i = 0; i < arrayLength; ++i) {
                    Object ref = Array.get(obj, i);
                    if (ref == null || visited.containsKey(ref)) continue;
                    visited.put(ref, ref);
                    queue.addFirst(ref);
                }
                continue;
            }
            ClassMetadata metadata = ObjectProfiler.getClassMetadata(objClass, metadataMap, caAction, faAction);
            Field[] fields = metadata.m_refFields;
            result += (long)metadata.m_shellSize;
            for (Field field : fields) {
                Object ref;
                try {
                    ref = field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot get field [" + field.getName() + "] of class [" + field.getDeclaringClass().getName() + "]: " + e.toString());
                }
                if (ref == null || visited.containsKey(ref)) continue;
                visited.put(ref, ref);
                queue.addFirst(ref);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassMetadata getClassMetadata(Class cls, Map metadataMap, ClassAccessPrivilegedAction caAction, FieldAccessPrivilegedAction faAction) {
        Field[] declaredFields;
        ClassMetadata result;
        if (null == cls) {
            return null;
        }
        Map map = metadataMap;
        synchronized (map) {
            result = (ClassMetadata)metadataMap.get(cls);
        }
        if (result != null) {
            return result;
        }
        int primitiveFieldCount = 0;
        int shellSize = 8;
        LinkedList<Field> refFields = new LinkedList<Field>();
        try {
            caAction.setContext(cls);
            declaredFields = (Field[])AccessController.doPrivileged(caAction);
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("could not access declared fields of class " + cls.getName() + ": " + pae.getException());
        }
        for (int f = 0; f < declaredFields.length; ++f) {
            Field field = declaredFields[f];
            if (Modifier.isStatic(field.getModifiers())) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive()) {
                shellSize += ObjectProfiler.sizeofPrimitiveType(fieldType);
                ++primitiveFieldCount;
                continue;
            }
            if (!field.isAccessible()) {
                try {
                    faAction.setContext(field);
                    AccessController.doPrivileged(faAction);
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException("could not make field " + field + " accessible: " + pae.getException());
                }
            }
            shellSize += 4;
            refFields.add(field);
        }
        ClassMetadata superMetadata = ObjectProfiler.getClassMetadata(cls.getSuperclass(), metadataMap, caAction, faAction);
        if (superMetadata != null) {
            primitiveFieldCount += superMetadata.m_primitiveFieldCount;
            shellSize += superMetadata.m_shellSize - 8;
            refFields.addAll(Arrays.asList(superMetadata.m_refFields));
        }
        Field[] _refFields = new Field[refFields.size()];
        refFields.toArray(_refFields);
        result = new ClassMetadata(primitiveFieldCount, shellSize, _refFields);
        Map map2 = metadataMap;
        synchronized (map2) {
            metadataMap.put(cls, result);
        }
        return result;
    }

    private static int sizeofArrayShell(int length, Class componentType) {
        int slotSize = componentType.isPrimitive() ? ObjectProfiler.sizeofPrimitiveType(componentType) : 4;
        return 16 + length * slotSize;
    }

    private static int sizeofPrimitiveType(Class type) {
        if (type == Integer.TYPE) {
            return 4;
        }
        if (type == Long.TYPE) {
            return 8;
        }
        if (type == Short.TYPE) {
            return 2;
        }
        if (type == Byte.TYPE) {
            return 1;
        }
        if (type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE) {
            return 2;
        }
        if (type == Double.TYPE) {
            return 8;
        }
        if (type == Float.TYPE) {
            return 4;
        }
        throw new IllegalArgumentException("not primitive: " + type);
    }

    private static int skipClassDueToSunJVMBug(Class clazz) {
        for (int i = 0; i < sunProblematicClasses.length; ++i) {
            Class sunPbClass = sunProblematicClasses[i];
            if (clazz != sunPbClass) continue;
            return (Integer)sunProblematicClassesSizes.get(clazz.getName());
        }
        return 0;
    }

    private static boolean isSharedFlyweight(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj == Boolean.TRUE || obj == Boolean.FALSE) {
            return true;
        }
        if (obj == Locale.ENGLISH || obj == Locale.FRENCH || obj == Locale.GERMAN || obj == Locale.ITALIAN || obj == Locale.JAPANESE || obj == Locale.KOREAN || obj == Locale.CHINESE || obj == Locale.SIMPLIFIED_CHINESE || obj == Locale.TRADITIONAL_CHINESE || obj == Locale.FRANCE || obj == Locale.GERMANY || obj == Locale.ITALY || obj == Locale.JAPAN || obj == Locale.KOREA || obj == Locale.CHINA || obj == Locale.PRC || obj == Locale.TAIWAN || obj == Locale.UK || obj == Locale.US || obj == Locale.CANADA || obj == Locale.CANADA_FRENCH) {
            return true;
        }
        if (obj == Collections.EMPTY_SET || obj == Collections.EMPTY_LIST || obj == Collections.EMPTY_MAP) {
            return true;
        }
        if (obj == BigInteger.ZERO || obj == BigInteger.ONE) {
            return true;
        }
        if (obj == System.in || obj == System.out || obj == System.err) {
            return true;
        }
        if (obj == String.CASE_INSENSITIVE_ORDER) {
            return true;
        }
        return obj == "META-INF/MANIFEST.MF";
    }

    static {
        HashMap<String, Integer> classesSizes = new HashMap<String, Integer>();
        classesSizes.put("java.lang.Class", Integers.valueOf(8));
        classesSizes.put("java.lang.Throwable", Integers.valueOf(24));
        classesSizes.put("sun.reflect.UnsafeStaticFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticBooleanFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticByteFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticShortFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticIntegerFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticLongFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticCharacterFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticFloatFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticDoubleFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("sun.reflect.UnsafeStaticObjectFieldAccessorImpl", Integers.valueOf(8));
        classesSizes.put("java.lang.Enum", Integers.valueOf(8));
        classesSizes.put("sun.reflect.ConstantPool", Integers.valueOf(16));
        sunProblematicClassesSizes = Collections.unmodifiableMap(classesSizes);
        ArrayList classes = new ArrayList(sunProblematicClassesSizes.size());
        for (Map.Entry entry : sunProblematicClassesSizes.entrySet()) {
            String className = (String)entry.getKey();
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {}
        }
        sunProblematicClasses = classes.toArray(new Class[0]);
    }

    private static final class FieldAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Field m_field;

        private FieldAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            this.m_field.setAccessible(true);
            return null;
        }

        void setContext(Field field) {
            this.m_field = field;
        }
    }

    private static final class ClassAccessPrivilegedAction
    implements PrivilegedExceptionAction {
        private Class m_cls;

        private ClassAccessPrivilegedAction() {
        }

        public Object run() throws Exception {
            return this.m_cls.getDeclaredFields();
        }

        void setContext(Class cls) {
            this.m_cls = cls;
        }
    }

    private static final class ClassMetadata {
        final int m_primitiveFieldCount;
        final int m_shellSize;
        final Field[] m_refFields;

        ClassMetadata(int primitiveFieldCount, int shellSize, Field[] refFields) {
            this.m_primitiveFieldCount = primitiveFieldCount;
            this.m_shellSize = shellSize;
            this.m_refFields = refFields;
        }
    }
}

