/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.sizeof;

import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class NaiveSizeOf {
    private static final int SZ_REF = 4;

    private NaiveSizeOf() {
    }

    public static int sizeof(boolean b) {
        return 1;
    }

    public static int sizeof(byte b) {
        return 1;
    }

    public static int sizeof(char c) {
        return 2;
    }

    public static int sizeof(short s) {
        return 2;
    }

    public static int sizeof(int i) {
        return 4;
    }

    public static int sizeof(long l) {
        return 8;
    }

    public static int sizeof(float f) {
        return 4;
    }

    public static int sizeof(double d) {
        return 8;
    }

    private static int size_inst(Class c) {
        Field[] flds = c.getDeclaredFields();
        int sz = 0;
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            if (!c.isInterface() && (f.getModifiers() & 8) != 0) continue;
            sz += NaiveSizeOf.size_prim(f.getType());
        }
        if (c.getSuperclass() != null) {
            sz += NaiveSizeOf.size_inst(c.getSuperclass());
        }
        Class<?>[] cv = c.getInterfaces();
        for (int i = 0; i < cv.length; ++i) {
            sz += NaiveSizeOf.size_inst(cv[i]);
        }
        return sz;
    }

    private static int size_prim(Class t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return 4;
    }

    private static int size_arr(Object obj, Class c) {
        Class<?> ct = c.getComponentType();
        int len = Array.getLength(obj);
        if (ct.isPrimitive()) {
            return len * NaiveSizeOf.size_prim(ct);
        }
        int sz = 0;
        for (int i = 0; i < len; ++i) {
            Class<?> c2;
            sz += 4;
            Object obj2 = Array.get(obj, i);
            if (obj2 == null || !(c2 = obj2.getClass()).isArray()) continue;
            sz += NaiveSizeOf.size_arr(obj2, c2);
        }
        return sz;
    }

    public static int sizeof(Object obj) {
        if (null == obj) {
            return 0;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            return NaiveSizeOf.size_arr(obj, c);
        }
        return NaiveSizeOf.size_inst(c);
    }
}

