/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.meta;

import com.alibaba.otter.shared.common.utils.meta.DdlSchemaFilter;
import com.alibaba.otter.shared.common.utils.meta.DdlTableNameFilter;
import com.alibaba.otter.shared.common.utils.meta.DdlUtilsFilter;
import com.alibaba.otter.shared.common.utils.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.MetaDataColumnDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class DdlUtils {
    private static final Logger logger = LoggerFactory.getLogger(DdlUtils.class);
    private static TableType[] SUPPORTED_TABLE_TYPES = new TableType[]{TableType.view, TableType.table};
    private static final Map<Integer, String> _defaultSizes = new HashMap<Integer, String>();

    public static List<String> findSchemas(JdbcTemplate jdbcTemplate, String schemaPattern) {
        try {
            if (StringUtils.isEmpty((String)schemaPattern)) {
                return jdbcTemplate.query("show databases", (RowMapper)new SingleColumnRowMapper(String.class));
            }
            return jdbcTemplate.query("show databases like ?", new Object[]{schemaPattern}, (RowMapper)new SingleColumnRowMapper(String.class));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static List<String> findSchemas(JdbcTemplate jdbcTemplate, String schemaPattern, DdlSchemaFilter ddlSchemaFilter) {
        List<String> schemas = DdlUtils.findSchemas(jdbcTemplate, schemaPattern);
        if (ddlSchemaFilter == null) {
            return schemas;
        }
        ArrayList<String> filterSchemas = new ArrayList<String>();
        for (String schema : schemas) {
            if (!ddlSchemaFilter.accept(schema)) continue;
            filterSchemas.add(schema);
        }
        return filterSchemas;
    }

    public static Table findTable(JdbcTemplate jdbcTemplate, String catalogName, String schemaName, String tableName) throws Exception {
        return DdlUtils.findTable(jdbcTemplate, catalogName, schemaName, tableName, null);
    }

    public static Table findTable(final JdbcTemplate jdbcTemplate, final String catalogName, final String schemaName, final String tableName, final DdlUtilsFilter filter) throws Exception {
        return (Table)jdbcTemplate.execute(new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                Table table = null;
                DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
                boolean isDRDS = false;
                try {
                    if (filter != null) {
                        con = filter.filterConnection(con);
                        Assert.notNull((Object)con);
                    }
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (filter != null) {
                        databaseMetaData = filter.filterDataBaseMetaData(jdbcTemplate, con, databaseMetaData);
                        Assert.notNull((Object)databaseMetaData);
                    }
                    String databaseName = databaseMetaData.getDatabaseProductName();
                    String version = databaseMetaData.getDatabaseProductVersion();
                    if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)"mysql") && StringUtils.contains((String)version, (String)"-TDDL-")) {
                        isDRDS = true;
                    }
                    metaData.setMetaData(databaseMetaData);
                    metaData.setTableTypes(TableType.toStrings(SUPPORTED_TABLE_TYPES));
                    metaData.setCatalog(catalogName);
                    metaData.setSchemaPattern(schemaName);
                    String convertTableName = tableName;
                    if (databaseMetaData.storesUpperCaseIdentifiers()) {
                        metaData.setCatalog(catalogName.toUpperCase());
                        metaData.setSchemaPattern(schemaName.toUpperCase());
                        convertTableName = tableName.toUpperCase();
                    }
                    if (databaseMetaData.storesLowerCaseIdentifiers()) {
                        metaData.setCatalog(catalogName.toLowerCase());
                        metaData.setSchemaPattern(schemaName.toLowerCase());
                        convertTableName = tableName.toLowerCase();
                    }
                    ResultSet tableData = null;
                    try {
                        tableData = metaData.getTables(convertTableName);
                        while (tableData != null && tableData.next()) {
                            Map values = DdlUtils.readColumns(tableData, DdlUtils.initColumnsForTable());
                            table = DdlUtils.readTable(metaData, values);
                            if (!table.getName().equalsIgnoreCase(tableName)) continue;
                            break;
                        }
                    }
                    finally {
                        JdbcUtils.closeResultSet((ResultSet)tableData);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                DdlUtils.makeAllColumnsPrimaryKeysIfNoPrimaryKeysFound(table);
                if (isDRDS) {
                    DdlUtils.makeDRDSShardColumnsAsPrimaryKeys(table, jdbcTemplate, catalogName, schemaName, tableName);
                }
                return table;
            }
        });
    }

    public static List<Table> findTables(final JdbcTemplate jdbcTemplate, final String catalogName, final String schemaName, final String tableNamePattern, final DdlUtilsFilter filter, final DdlTableNameFilter tableNameFilter) throws Exception {
        return (List)jdbcTemplate.execute(new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                ArrayList<Table> tables = new ArrayList<Table>();
                DatabaseMetaDataWrapper metaData = new DatabaseMetaDataWrapper();
                boolean isDRDS = false;
                try {
                    if (filter != null) {
                        con = filter.filterConnection(con);
                        Assert.notNull((Object)con);
                    }
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (filter != null) {
                        databaseMetaData = filter.filterDataBaseMetaData(jdbcTemplate, con, databaseMetaData);
                        Assert.notNull((Object)databaseMetaData);
                    }
                    String databaseName = databaseMetaData.getDatabaseProductName();
                    String version = databaseMetaData.getDatabaseProductVersion();
                    if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)"mysql") && StringUtils.contains((String)version, (String)"-TDDL-")) {
                        isDRDS = true;
                    }
                    metaData.setMetaData(databaseMetaData);
                    metaData.setTableTypes(TableType.toStrings(SUPPORTED_TABLE_TYPES));
                    metaData.setCatalog(catalogName);
                    metaData.setSchemaPattern(schemaName);
                    String convertTableName = tableNamePattern;
                    if (databaseMetaData.storesUpperCaseIdentifiers()) {
                        metaData.setCatalog(catalogName.toUpperCase());
                        metaData.setSchemaPattern(schemaName.toUpperCase());
                        convertTableName = tableNamePattern.toUpperCase();
                    }
                    if (databaseMetaData.storesLowerCaseIdentifiers()) {
                        metaData.setCatalog(catalogName.toLowerCase());
                        metaData.setSchemaPattern(schemaName.toLowerCase());
                        convertTableName = tableNamePattern.toLowerCase();
                    }
                    ResultSet tableData = null;
                    try {
                        tableData = metaData.getTables(convertTableName);
                        while (tableData != null && tableData.next()) {
                            Map values = DdlUtils.readColumns(tableData, DdlUtils.initColumnsForTable());
                            Table table = DdlUtils.readTable(metaData, values);
                            if (tableNameFilter != null && !tableNameFilter.accept(catalogName, schemaName, table.getName())) continue;
                            tables.add(table);
                        }
                    }
                    finally {
                        JdbcUtils.closeResultSet((ResultSet)tableData);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                for (Table table : tables) {
                    DdlUtils.makeAllColumnsPrimaryKeysIfNoPrimaryKeysFound(table);
                    if (!isDRDS) continue;
                    DdlUtils.makeDRDSShardColumnsAsPrimaryKeys(table, jdbcTemplate, catalogName, schemaName, table.getName());
                }
                return tables;
            }
        });
    }

    private static void makeAllColumnsPrimaryKeysIfNoPrimaryKeysFound(Table table) {
        if (table != null && table.getPrimaryKeyColumns() != null && table.getPrimaryKeyColumns().length == 0) {
            Column[] allCoumns;
            for (Column column : allCoumns = table.getColumns()) {
                column.setPrimaryKey(true);
            }
        }
    }

    private static void makeDRDSShardColumnsAsPrimaryKeys(Table table, JdbcTemplate jdbcTemplate, String catalogName, String schemaName, String tableName) {
        String shardColumns = DdlUtils.getShardKeyByDRDS(jdbcTemplate, catalogName, schemaName, tableName);
        if (StringUtils.isNotEmpty((String)shardColumns)) {
            String[] columns;
            for (String key : columns = StringUtils.split((String)shardColumns, (char)',')) {
                Column col = table.findColumn(key, false);
                if (col == null) {
                    throw new NullPointerException(String.format("%s pk %s is null", tableName, key));
                }
                col.setPrimaryKey(true);
            }
        }
    }

    public static String getShardKeyByDRDS(JdbcTemplate jdbcTemplate, String catalogName, String schemaName, final String tableName) {
        try {
            return (String)jdbcTemplate.execute("show partitions from ?", new PreparedStatementCallback(){

                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    DatabaseMetaData metaData = ps.getConnection().getMetaData();
                    String convertTableName = tableName;
                    if (metaData.storesUpperCaseIdentifiers()) {
                        convertTableName = tableName.toUpperCase();
                    }
                    if (metaData.storesLowerCaseIdentifiers()) {
                        convertTableName = tableName.toLowerCase();
                    }
                    String tName = convertTableName;
                    ps.setString(1, tName);
                    ResultSet rs = ps.executeQuery();
                    String log = null;
                    if (rs.next()) {
                        log = rs.getString("KEYS");
                    }
                    rs.close();
                    return log;
                }
            });
        }
        catch (DataAccessException e) {
            Throwable cause = e.getRootCause();
            if (cause instanceof SQLException && ((SQLException)cause).getErrorCode() == 1146) {
                return null;
            }
            throw e;
        }
    }

    private static Table readTable(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String tableName = (String)values.get("TABLE_NAME");
        Table table = null;
        if (tableName != null && tableName.length() > 0) {
            table = new Table();
            table.setName(tableName);
            table.setType((String)values.get("TABLE_TYPE"));
            table.setCatalog((String)values.get("TABLE_CAT"));
            table.setSchema((String)values.get("TABLE_SCHEM"));
            table.setDescription((String)values.get("REMARKS"));
            table.addColumns(DdlUtils.readColumns(metaData, tableName));
            Collection<String> primaryKeys = DdlUtils.readPrimaryKeyNames(metaData, tableName);
            for (String key : primaryKeys) {
                Column col = table.findColumn(key, true);
                if (col != null) {
                    col.setPrimaryKey(true);
                    continue;
                }
                throw new NullPointerException(String.format("%s pk %s is null - %s %s", tableName, key, ToStringBuilder.reflectionToString((Object)metaData, (ToStringStyle)ToStringStyle.SIMPLE_STYLE), ToStringBuilder.reflectionToString(values, (ToStringStyle)ToStringStyle.SIMPLE_STYLE)));
            }
        }
        return table;
    }

    private static List<MetaDataColumnDescriptor> initColumnsForTable() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_TYPE", 12, (Object)"UNKNOWN"));
        result.add(new MetaDataColumnDescriptor("TABLE_CAT", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_SCHEM", 12));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    private static List<MetaDataColumnDescriptor> initColumnsForColumn() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_DEF", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TYPE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("DATA_TYPE", 4, (Object)new Integer(1111)));
        result.add(new MetaDataColumnDescriptor("NUM_PREC_RADIX", 4, (Object)new Integer(10)));
        result.add(new MetaDataColumnDescriptor("DECIMAL_DIGITS", 4, (Object)new Integer(0)));
        result.add(new MetaDataColumnDescriptor("COLUMN_SIZE", 12));
        result.add(new MetaDataColumnDescriptor("IS_NULLABLE", 12, (Object)"YES"));
        result.add(new MetaDataColumnDescriptor("REMARKS", 12));
        return result;
    }

    private static List<MetaDataColumnDescriptor> initColumnsForPK() {
        ArrayList<MetaDataColumnDescriptor> result = new ArrayList<MetaDataColumnDescriptor>();
        result.add(new MetaDataColumnDescriptor("COLUMN_NAME", 12));
        result.add(new MetaDataColumnDescriptor("TABLE_NAME", 12));
        result.add(new MetaDataColumnDescriptor("PK_NAME", 12));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Column> readColumns(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<Column> arrayList;
        ResultSet columnData = null;
        try {
            Map<String, Object> tmp;
            columnData = metaData.getColumns(tableName, null);
            ArrayList<Column> columns = new ArrayList<Column>();
            Map<String, Object> values = null;
            while (columnData.next() && tableName.equalsIgnoreCase((String)(tmp = DdlUtils.readColumns(columnData, DdlUtils.initColumnsForColumn())).get("TABLE_NAME"))) {
                values = tmp;
                columns.add(DdlUtils.readColumn(metaData, values));
            }
            arrayList = columns;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(columnData);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)columnData);
        return arrayList;
    }

    private static Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        String size;
        Integer precision;
        Column column = new Column();
        column.setName((String)values.get("COLUMN_NAME"));
        column.setDefaultValue((String)values.get("COLUMN_DEF"));
        column.setTypeCode(((Integer)values.get("DATA_TYPE")).intValue());
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.startsWith("TIMESTAMP")) {
            column.setTypeCode(93);
        }
        if (typeName != null && StringUtils.containsIgnoreCase((String)typeName, (String)"UNSIGNED")) {
            switch (column.getTypeCode()) {
                case -6: {
                    column.setTypeCode(5);
                    break;
                }
                case 5: {
                    column.setTypeCode(4);
                    break;
                }
                case 4: {
                    column.setTypeCode(-5);
                    break;
                }
                case -5: {
                    column.setTypeCode(3);
                    break;
                }
            }
        }
        if ((precision = (Integer)values.get("NUM_PREC_RADIX")) != null) {
            column.setPrecisionRadix(precision.intValue());
        }
        if ((size = (String)values.get("COLUMN_SIZE")) == null) {
            size = _defaultSizes.get(new Integer(column.getTypeCode()));
        }
        column.setSize(size);
        int scale = 0;
        Object dec_digits = values.get("DECIMAL_DIGITS");
        if (dec_digits instanceof String) {
            scale = dec_digits == null ? 0 : NumberUtils.toInt((String)dec_digits.toString());
        } else if (dec_digits instanceof Integer) {
            int n = scale = dec_digits == null ? 0 : (Integer)dec_digits;
        }
        if (scale != 0) {
            column.setScale(scale);
        }
        column.setRequired("NO".equalsIgnoreCase(((String)values.get("IS_NULLABLE")).trim()));
        column.setDescription((String)values.get("REMARKS"));
        return column;
    }

    private static Map<String, Object> readColumns(ResultSet resultSet, List<MetaDataColumnDescriptor> columnDescriptors) throws SQLException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (MetaDataColumnDescriptor descriptor : columnDescriptors) {
            values.put(descriptor.getName(), descriptor.readColumn(resultSet));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> readPrimaryKeyNames(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<String> arrayList;
        ResultSet pkData = null;
        try {
            ArrayList<String> pks = new ArrayList<String>();
            pkData = metaData.getPrimaryKeys(tableName);
            while (pkData.next()) {
                Map<String, Object> values = DdlUtils.readColumns(pkData, DdlUtils.initColumnsForPK());
                pks.add(DdlUtils.readPrimaryKeyName(metaData, values));
            }
            arrayList = pks;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(pkData);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)pkData);
        return arrayList;
    }

    private static String readPrimaryKeyName(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        return (String)values.get("COLUMN_NAME");
    }

    static {
        _defaultSizes.put(new Integer(1), "254");
        _defaultSizes.put(new Integer(12), "254");
        _defaultSizes.put(new Integer(-1), "254");
        _defaultSizes.put(new Integer(-2), "254");
        _defaultSizes.put(new Integer(-3), "254");
        _defaultSizes.put(new Integer(-4), "254");
        _defaultSizes.put(new Integer(4), "32");
        _defaultSizes.put(new Integer(-5), "64");
        _defaultSizes.put(new Integer(7), "7,0");
        _defaultSizes.put(new Integer(6), "15,0");
        _defaultSizes.put(new Integer(8), "15,0");
        _defaultSizes.put(new Integer(3), "15,15");
        _defaultSizes.put(new Integer(2), "15,15");
    }
}

