/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.extension.classpath;

import com.alibaba.otter.shared.common.utils.extension.classpath.ClassScanner;
import com.alibaba.otter.shared.common.utils.extension.classpath.FileSystemClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FileSystemClassScanner
implements InitializingBean,
ClassScanner {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClassScanner.class);
    private static final String CLASS_FILE = ".class";
    private static final String JAR_FILE = ".jar";
    private String extendsDir;
    private FileSystemClassLoader fileClassLoader;

    public void afterPropertiesSet() throws Exception {
        this.fileClassLoader = new FileSystemClassLoader(this.extendsDir, this.getClass().getClassLoader());
    }

    @Override
    public Class<?> scan(String className) {
        return this.findInDirectory(this.extendsDir, className);
    }

    private Class<?> findInDirectory(String dirStr, String className) {
        File dir = this.StrToFile(dirStr);
        File[] files = dir.listFiles();
        String rootPath = dir.getPath();
        for (File file : files) {
            Class<?> clz;
            if (file.isFile()) {
                String classFileName = file.getPath();
                if (classFileName.endsWith(CLASS_FILE)) {
                    String tempClassName = classFileName.substring(rootPath.length() - className.lastIndexOf("."), classFileName.length() - CLASS_FILE.length());
                    if (!className.equals(this.pathToDot(tempClassName))) continue;
                    try {
                        return this.fileClassLoader.loadClass(className);
                    }
                    catch (Exception ex) {
                        logger.warn("WARN ## load this class has an error,the fileName is = " + className, (Throwable)ex);
                        continue;
                    }
                }
                if (!classFileName.endsWith(JAR_FILE)) continue;
                return this.scanInJar(classFileName, className);
            }
            if (!file.isDirectory() || (clz = this.findInDirectory(file.toString(), className)) == null) continue;
            return clz;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> scanInJar(String jarFileName, String className) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(jarFileName);
            Enumeration<? extends ZipEntry> zipenum = zipfile.entries();
            ZipEntry entry = null;
            String tempClassName = null;
            while (zipenum.hasMoreElements()) {
                entry = zipenum.nextElement();
                tempClassName = entry.getName();
                if (!tempClassName.endsWith(CLASS_FILE) || !(tempClassName = StringUtils.replace((String)FilenameUtils.removeExtension((String)tempClassName), (String)"/", (String)".")).equals(className)) continue;
                try {
                    Class<?> clazz = this.fileClassLoader.loadClass(className);
                    return clazz;
                }
                catch (Exception ex) {
                    try {
                        logger.warn("WARN ## load this class has an error,the fileName is = " + className, (Throwable)ex);
                    }
                    catch (IOException ex2) {
                        logger.error(ex2.getMessage(), (Throwable)ex2);
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private File StrToFile(String dirString) {
        File file = new File(dirString);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private String pathToDot(String s) {
        return s.replace('/', '.').replace('\\', '.');
    }

    public void setExtendsDir(String extendsDir) {
        this.extendsDir = extendsDir;
        File dir = new File(extendsDir);
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                logger.error("##ERROR", (Throwable)e);
            }
        }
    }

    public void setFileClassLoader(FileSystemClassLoader fileClassLoader) {
        this.fileClassLoader = fileClassLoader;
    }
}

