/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.extension.classpath;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClassLoader.class);
    private String rootDir;

    public FileSystemClassLoader(String rootDir, ClassLoader parent) {
        super(parent);
        this.rootDir = rootDir;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classData = this.getClassData(name);
        if (classData == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, classData, 0, classData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassData(String className) {
        String path = this.classNameToPath(className);
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            int bytesNumRead = 0;
            while ((bytesNumRead = ((InputStream)ins).read(buffer)) != -1) {
                baos.write(buffer, 0, bytesNumRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error("ERROR ## get class data has an error", (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException e) {
                    logger.error("ERROR ## close inputstream has an error", (Throwable)e);
                }
            }
        }
        return null;
    }

    private String classNameToPath(String className) {
        return this.rootDir + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
    }
}

