/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.extension;

import com.alibaba.otter.shared.common.model.config.data.ExtensionData;
import com.alibaba.otter.shared.common.utils.cache.ExtensionMemoryMirror;
import com.alibaba.otter.shared.common.utils.compile.impl.JdkCompiler;
import com.alibaba.otter.shared.common.utils.compile.model.JavaSource;
import com.alibaba.otter.shared.common.utils.extension.ExtensionFactory;
import com.alibaba.otter.shared.common.utils.extension.classpath.ClassScanner;
import com.alibaba.otter.shared.common.utils.extension.exceptions.ExtensionLoadException;
import org.apache.commons.lang.StringUtils;

public class DefaultExtensionFactory
implements ExtensionFactory {
    private ExtensionMemoryMirror<ExtensionData, Object> resolverCache = new ExtensionMemoryMirror<ExtensionData, Object>(new ExtensionMemoryMirror.ComputeFunction<ExtensionData, Object>(){

        @Override
        public Object apply(ExtensionData extensionData) {
            return DefaultExtensionFactory.this.getExtensionInternal(extensionData);
        }
    });
    private ClassScanner classPathScanner;
    private ClassScanner fileSystemScanner;
    private JdkCompiler jdkCompiler;

    @Override
    public <T> T getExtension(Class<T> type, ExtensionData extensionData) {
        return (T)this.resolverCache.get(extensionData);
    }

    private Object getExtensionInternal(ExtensionData extensionData) {
        Class clazz = null;
        String fullname = "";
        if (extensionData.getExtensionDataType().isClazz() && StringUtils.isNotBlank((String)extensionData.getClazzPath())) {
            clazz = this.scan(extensionData.getClazzPath());
            fullname = "[" + extensionData.getClazzPath() + "]ClassPath";
        } else if (extensionData.getExtensionDataType().isSource() && StringUtils.isNotBlank((String)extensionData.getSourceText())) {
            JavaSource javaSource = new JavaSource(extensionData.getSourceText());
            clazz = this.jdkCompiler.compile(javaSource);
            fullname = "[" + javaSource.toString() + "]SourceText";
        }
        if (clazz == null) {
            throw new ExtensionLoadException("ERROR ## classload this fileresolver=" + fullname + " has an error");
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExtensionLoadException("ERROR ## classload this fileresolver=" + fullname + " has an error", e);
        }
    }

    private Class scan(String fileResolverClassname) {
        Class<?> clazz = this.classPathScanner.scan(fileResolverClassname);
        if (clazz == null) {
            clazz = this.fileSystemScanner.scan(fileResolverClassname);
        }
        return clazz;
    }

    public void setClassPathScanner(ClassScanner classPathScanner) {
        this.classPathScanner = classPathScanner;
    }

    public void setFileSystemScanner(ClassScanner fileSystemScanner) {
        this.fileSystemScanner = fileSystemScanner;
    }

    public ClassScanner getFileSystemScanner() {
        return this.fileSystemScanner;
    }

    public void setJdkCompiler(JdkCompiler jdkCompiler) {
        this.jdkCompiler = jdkCompiler;
    }
}

