/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.compile.model;

import com.alibaba.otter.shared.common.utils.compile.model.JavaFileObjectImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public final class JdkCompilerClassLoader
extends ClassLoader {
    private final Map<String, JavaFileObject> classes = new HashMap<String, JavaFileObject>();

    public JdkCompilerClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public Collection<JavaFileObject> files() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public void clearCache() {
        this.classes.clear();
    }

    public JavaFileObject getJavaFileObject(String qualifiedClassName) {
        return this.classes.get(qualifiedClassName);
    }

    @Override
    protected synchronized Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        JavaFileObject file = this.classes.get(qualifiedClassName);
        if (file != null) {
            byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
            return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
        }
        try {
            return Class.forName(qualifiedClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(qualifiedClassName);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return super.findClass(qualifiedClassName);
            }
        }
    }

    public void add(String qualifiedClassName, JavaFileObject javaFile) {
        this.classes.put(qualifiedClassName, javaFile);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = this.findClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String qualifiedClassName;
        JavaFileObjectImpl file;
        if (name.endsWith(".class") && (file = (JavaFileObjectImpl)this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
            return new ByteArrayInputStream(file.getByteCode());
        }
        return super.getResourceAsStream(name);
    }
}

