/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.compile.model;

import com.alibaba.otter.shared.common.utils.compile.impl.JdkCompileTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaFileObjectImpl
extends SimpleJavaFileObject {
    private ByteArrayOutputStream byteCode = new ByteArrayOutputStream();
    private final CharSequence source;

    public JavaFileObjectImpl(String baseName, CharSequence source) {
        super(JdkCompileTask.toURI(baseName + ".java"), JavaFileObject.Kind.SOURCE);
        this.source = source;
    }

    public JavaFileObjectImpl(String name, JavaFileObject.Kind kind) {
        super(JdkCompileTask.toURI(name), kind);
        this.source = null;
    }

    public JavaFileObjectImpl(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.source = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
        if (this.source == null) {
            throw new UnsupportedOperationException();
        }
        return this.source;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        return this.byteCode;
    }

    public byte[] getByteCode() {
        return this.byteCode.toByteArray();
    }
}

