/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.compile.impl;

import com.alibaba.otter.shared.common.utils.compile.JavaSourceCompiler;
import com.alibaba.otter.shared.common.utils.compile.exception.CompileExprException;
import com.alibaba.otter.shared.common.utils.compile.exception.JdkCompileException;
import com.alibaba.otter.shared.common.utils.compile.impl.JdkCompileTask;
import com.alibaba.otter.shared.common.utils.compile.model.JavaSource;
import com.alibaba.otter.shared.common.utils.compile.model.JdkCompilerClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class JdkCompiler
implements JavaSourceCompiler {
    private List<String> options = new ArrayList<String>();

    @Override
    public Class compile(String sourceString) {
        JavaSource source = new JavaSource(sourceString);
        return this.compile(source);
    }

    @Override
    public Class compile(JavaSource javaSource) {
        try {
            DiagnosticCollector<JavaFileObject> errs = new DiagnosticCollector<JavaFileObject>();
            JdkCompileTask compileTask = new JdkCompileTask(new JdkCompilerClassLoader(this.getClass().getClassLoader()), this.options);
            String fullName = javaSource.getPackageName() + "." + javaSource.getClassName();
            Class newClass = compileTask.compile(fullName, javaSource.getSource(), errs);
            return newClass;
        }
        catch (JdkCompileException ex) {
            DiagnosticCollector<JavaFileObject> diagnostics = ex.getDiagnostics();
            throw new CompileExprException("compile error, source : \n" + javaSource + ", " + diagnostics.getDiagnostics(), ex);
        }
        catch (Exception ex) {
            throw new CompileExprException("compile error, source : \n" + javaSource, ex);
        }
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }
}

