/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.compile.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class JdkCompileException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Set<String> classNames;
    private transient DiagnosticCollector<JavaFileObject> diagnostics;
    private String source;

    public JdkCompileException(String message, Set<String> qualifiedClassNames, Throwable cause, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(message, cause);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public JdkCompileException(String message, Set<String> qualifiedClassNames, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(message);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    public JdkCompileException(Set<String> qualifiedClassNames, Throwable cause, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(cause);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    private void setClassNames(Set<String> qualifiedClassNames) {
        this.classNames = new HashSet<String>(qualifiedClassNames);
    }

    private void setDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public DiagnosticCollector<JavaFileObject> getDiagnostics() {
        return this.diagnostics;
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableSet(this.classNames);
    }
}

