/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class StreamAppender {
    private Thread errWriter;
    private Thread outWriter;
    private PrintWriter output;

    public StreamAppender(OutputStream output) {
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter(output)));
    }

    public void writeInput(final InputStream err, final InputStream out) {
        this.errWriter = new Thread(){
            BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(err));
            }

            @Override
            public void run() {
                try {
                    String line = null;
                    while ((line = this.reader.readLine()) != null) {
                        StreamAppender.this.output.println(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    StreamAppender.this.output.flush();
                    IOUtils.closeQuietly((Reader)this.reader);
                }
            }
        };
        this.outWriter = new Thread(){
            BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(out));
            }

            @Override
            public void run() {
                try {
                    String line = null;
                    while ((line = this.reader.readLine()) != null) {
                        StreamAppender.this.output.println(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    StreamAppender.this.output.flush();
                    IOUtils.closeQuietly((Reader)this.reader);
                }
            }
        };
        this.errWriter.setDaemon(true);
        this.outWriter.setDaemon(true);
        this.errWriter.start();
        this.outWriter.start();
    }

    public void finish() throws Exception {
        this.outWriter.join();
        this.errWriter.join();
    }
}

