/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.cmd;

import com.alibaba.otter.shared.common.utils.cmd.StreamAppender;
import com.alibaba.otter.shared.common.utils.cmd.StreamCollector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    private static final Logger logger = LoggerFactory.getLogger(Exec.class);

    public static Result execute(String cmd) throws Exception {
        return Exec.execute(cmd, null, null, null);
    }

    public static Result execute(String cmd, String outputLog) throws Exception {
        return Exec.execute(cmd, outputLog, null, null);
    }

    public static Result execute(String cmd, String outputLog, byte[] input) throws Exception {
        return Exec.execute(cmd, outputLog, input, null);
    }

    public static Result execute(String cmd, String outputLog, byte[] input, File workingDir) throws Exception {
        Process process = Runtime.getRuntime().exec(cmd, null, workingDir);
        return Exec.execute(process, cmd, outputLog, input, workingDir);
    }

    public static Result execute(String[] cmds) throws Exception {
        return Exec.execute(cmds, null, null, null);
    }

    public static Result execute(String[] cmds, String outputLog) throws Exception {
        return Exec.execute(cmds, outputLog, null, null);
    }

    public static Result execute(String[] cmds, String outputLog, byte[] input) throws Exception {
        return Exec.execute(cmds, outputLog, input, null);
    }

    public static Result execute(String[] cmds, String outputLog, byte[] input, File workingDir) throws Exception {
        Process process = Runtime.getRuntime().exec(cmds, null, workingDir);
        return Exec.execute(process, StringUtils.join((Object[])cmds, (String)" "), outputLog, input, workingDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execute(Process process, String cmd, String outputLog, byte[] input, File workingDir) throws Exception {
        Result result;
        InputPumper inputThread = new InputPumper(input == null ? new byte[]{} : input, process.getOutputStream());
        StreamCollector stderr = null;
        StreamCollector stdout = null;
        FileOutputStream fileOutput = null;
        StreamAppender outputLogger = null;
        String errString = null;
        String outString = null;
        try {
            if (outputLog == null) {
                stdout = new StreamCollector(process.getInputStream());
                stderr = new StreamCollector(process.getErrorStream());
                stdout.start();
                stderr.start();
            } else {
                errString = "stderr output redirected to file " + outputLog;
                outString = "stdout output redirected to file " + outputLog;
                fileOutput = new FileOutputStream(outputLog);
                outputLogger = new StreamAppender(fileOutput);
                outputLogger.writeInput(process.getErrorStream(), process.getInputStream());
            }
            inputThread.start();
            int exitCode = process.waitFor();
            inputThread.join();
            if (outputLogger != null) {
                outputLogger.finish();
            }
            if (stdout != null) {
                stdout.join();
                outString = stdout.toString();
            }
            if (stderr != null) {
                stderr.join();
                errString = stderr.toString();
            }
            result = new Result(cmd.toString(), outString, errString, exitCode);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutput);
            if (process != null) {
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                process.destroy();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutput);
        if (process != null) {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            process.destroy();
        }
        return result;
    }

    public static class Result {
        private final String cmd;
        private final int exitCode;
        private final String stderr;
        private final String stdout;

        private Result(String cmd, String stdout, String stderr, int exitCode) {
            this.cmd = cmd;
            this.stdout = stdout;
            this.stderr = stderr;
            this.exitCode = exitCode;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String toString() {
            return String.format("Command: %s%sexit code:%s%sstdout:%s%s%sstderr:%s%s%s", this.cmd, SystemUtils.LINE_SEPARATOR, this.exitCode, SystemUtils.LINE_SEPARATOR, SystemUtils.LINE_SEPARATOR, this.stdout, SystemUtils.LINE_SEPARATOR, SystemUtils.LINE_SEPARATOR, this.stderr, SystemUtils.LINE_SEPARATOR);
        }
    }

    private static class InputPumper
    extends Thread {
        private final InputStream input;
        private final OutputStream output;

        InputPumper(byte[] input, OutputStream output) {
            this.output = output;
            this.input = new ByteArrayInputStream(input);
            this.setName("Input Pumper");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.input, (OutputStream)this.output);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.output);
            }
        }
    }
}

