/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils.cache;

import com.alibaba.otter.shared.common.utils.OtterToStringStyle;
import com.google.common.collect.MapMaker;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class RefreshMemoryMirror<KEY, VALUE> {
    private final Long period;
    private final Map<String, RefreshObject<VALUE>> store;
    private final ComputeFunction<KEY, VALUE> function;

    public RefreshMemoryMirror(Long period, ComputeFunction<KEY, VALUE> function) {
        this.period = period;
        this.function = function;
        this.store = new MapMaker().makeMap();
    }

    public synchronized VALUE get(KEY key) {
        RefreshObject<VALUE> object = this.store.get(this.getKey(key));
        if (object == null) {
            VALUE result = this.function.apply(key, null);
            this.put(key, result);
            return result;
        }
        if (this.isExpired(object)) {
            VALUE result = this.function.apply(key, object.getValue());
            this.put(key, result);
            return result;
        }
        return object.getValue();
    }

    public synchronized void put(KEY key, VALUE value) {
        RefreshObject<VALUE> object = new RefreshObject<VALUE>(value);
        this.store.put(this.getKey(key), object);
    }

    public synchronized void remove(Object key) {
        this.store.remove(this.getKey(key));
    }

    public synchronized void clear() {
        this.store.clear();
    }

    public Iterator getKeys() {
        return this.store.keySet().iterator();
    }

    private boolean isExpired(RefreshObject refreshObject) {
        if (refreshObject == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(refreshObject.getTimestamp());
        calendar.add(14, this.period.intValue());
        Date now = new Date();
        return now.after(calendar.getTime());
    }

    private String getKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Cache key not be null");
        }
        return ObjectUtils.toString((Object)key);
    }

    public String toString() {
        return "RefreshMemoryCache[period=" + this.period + ", size=" + this.store.size() + "]";
    }

    public static class RefreshObject<VALUE> {
        private long timestamp;
        private VALUE value;

        public RefreshObject(VALUE value) {
            this.value = value;
            this.timestamp = new Date().getTime();
        }

        public VALUE getValue() {
            return this.value;
        }

        public void setValue(VALUE value) {
            this.value = value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)OtterToStringStyle.SIMPLE_STYLE);
        }
    }

    public static interface ComputeFunction<KEY, VALUE> {
        public VALUE apply(KEY var1, VALUE var2);
    }
}

