/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;

public class TestUtils {
    public static Object getField(Object obj, String fieldName) {
        Field field = ReflectionUtils.findField(obj.getClass(), (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)obj);
    }

    public static void setField(Object target, String fieldName, Object args) throws Exception {
        Field field = ReflectionUtils.findField(target.getClass(), (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)target, (Object)args);
    }

    public static Object invokeMethod(Object target, String methodName, Object ... args) throws Exception {
        Method method = null;
        if (args == null || args.length == 0) {
            method = ReflectionUtils.findMethod(target.getClass(), (String)methodName);
        } else {
            Class[] argsClass = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsClass[i] = args[i].getClass();
            }
            method = ReflectionUtils.findMethod(target.getClass(), (String)methodName, (Class[])argsClass);
        }
        ReflectionUtils.makeAccessible((Method)method);
        if (args == null || args.length == 0) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)target);
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])args);
    }

    public static void restoreJvm() {
        int maxRestoreJvmLoops = 10;
        long memUsedPrev = TestUtils.memoryUsed();
        for (int i = 0; i < maxRestoreJvmLoops; ++i) {
            System.runFinalization();
            System.gc();
            long memUsedNow = TestUtils.memoryUsed();
            if (ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount() == 0 && memUsedNow >= memUsedPrev) break;
            memUsedPrev = memUsedNow;
        }
    }

    public static long memoryUsed() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }
}

