/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioUtils {
    private static final Logger logger = LoggerFactory.getLogger(NioUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int timeWait = 1000;

    public static long copy(InputStream input, OutputStream output, long offset) throws IOException {
        long count = 0L;
        long n = 0L;
        if (input instanceof FileInputStream) {
            FileChannel inChannel = ((FileInputStream)input).getChannel();
            WritableByteChannel outChannel = Channels.newChannel(output);
            count = inChannel.transferTo(offset, inChannel.size() - offset, outChannel);
        } else if (output instanceof FileOutputStream) {
            FileChannel outChannel = ((FileOutputStream)output).getChannel();
            ReadableByteChannel inChannel = Channels.newChannel(input);
            do {
                n = outChannel.transferFrom(inChannel, offset + count, 8192L);
                count += n;
            } while (n > 0L);
        } else {
            byte[] buffer = new byte[8192];
            input.skip(offset);
            while (-1L != (n = (long)input.read(buffer))) {
                output.write(buffer, 0, (int)n);
                count += n;
            }
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output, long offset, long count) throws IOException {
        long rcount = 0L;
        long n = 0L;
        if (input instanceof FileInputStream) {
            FileChannel inChannel = ((FileInputStream)input).getChannel();
            WritableByteChannel outChannel = Channels.newChannel(output);
            rcount = inChannel.transferTo(offset, count, outChannel);
        } else if (output instanceof FileOutputStream) {
            FileChannel outChannel = ((FileOutputStream)output).getChannel();
            ReadableByteChannel inChannel = Channels.newChannel(input);
            do {
                n = count < 8192L ? outChannel.transferFrom(inChannel, offset + rcount, count) : outChannel.transferFrom(inChannel, offset + rcount, 8192L);
                count -= n;
                rcount += n;
            } while (n > 0L);
        } else {
            byte[] buffer = new byte[8192];
            input.skip(offset);
            while (count > 0L) {
                n = count < 8192L ? (long)input.read(buffer, 0, (int)count) : (long)input.read(buffer, 0, 8192);
                output.write(buffer, 0, (int)n);
                count -= n;
                rcount += n;
            }
        }
        return rcount;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        long n = 0L;
        if (input instanceof FileInputStream) {
            FileChannel inChannel = ((FileInputStream)input).getChannel();
            WritableByteChannel outChannel = Channels.newChannel(output);
            count = inChannel.transferTo(0L, inChannel.size(), outChannel);
        } else if (output instanceof FileOutputStream) {
            FileChannel outChannel = ((FileOutputStream)output).getChannel();
            ReadableByteChannel inChannel = Channels.newChannel(input);
            do {
                n = outChannel.transferFrom(inChannel, count, 8192L);
                count += n;
            } while (n > 0L);
        } else {
            byte[] buffer = new byte[8192];
            while (-1L != (n = (long)input.read(buffer))) {
                output.write(buffer, 0, (int)n);
                count += n;
            }
        }
        return count;
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(data);
            NioUtils.copy(input, output);
            output.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public static void write(byte[] srcArray, File targetFile) throws IOException {
        NioUtils.write(srcArray, targetFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(byte[] srcArray, File targetFile, boolean overwrite) throws IOException {
        if (srcArray == null) {
            throw new IOException("Source must not be null");
        }
        if (targetFile == null) {
            throw new IOException("Target must not be null");
        }
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                throw new IOException("Target '" + targetFile.getAbsolutePath() + "' is directory!");
            }
            if (!targetFile.isFile()) throw new IOException("Invalid target object '" + targetFile.getAbsolutePath() + "'!");
            if (!overwrite) {
                throw new IOException("Target file '" + targetFile.getAbsolutePath() + "' already exists!");
            }
        } else {
            NioUtils.create(targetFile.getParentFile(), false, 3);
        }
        ByteArrayInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new ByteArrayInputStream(srcArray);
            output = new FileOutputStream(targetFile);
            NioUtils.copy(input, output);
            output.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File sourceFile) throws IOException {
        byte[] byArray;
        if (sourceFile == null) {
            throw new IOException("Source must not be null");
        }
        if (!sourceFile.exists()) {
            throw new IOException("Source '" + sourceFile + "' does not exist");
        }
        if (sourceFile.isDirectory()) {
            throw new IOException("Source '" + sourceFile + "' exists but is a directory");
        }
        FileInputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            input = new FileInputStream(sourceFile);
            output = new ByteArrayOutputStream();
            NioUtils.copy(input, output);
            output.flush();
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
        return byArray;
    }

    public static byte[] read(InputStream input) throws IOException {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            NioUtils.copy(input, output);
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public static void copy(File src, File dest) throws IOException {
        NioUtils.copy(src, dest, 1);
    }

    public static boolean copy(File src, File dest, int retryTimes) throws IOException {
        int totalRetry = retryTimes;
        if (retryTimes < 1) {
            totalRetry = 1;
        }
        int retry = 0;
        while (retry++ < totalRetry) {
            try {
                NioUtils.copy(src, dest, true);
                return true;
            }
            catch (Exception ex) {
                int wait = (int)Math.pow(retry, retry) * 1000;
                int n = wait = wait < 1000 ? 1000 : wait;
                if (retry == totalRetry) {
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException(ex == null ? "unknow error" : ex.getMessage(), ex);
                }
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File sourceFile, File targetFile, boolean overwrite) throws IOException {
        if (sourceFile == null) {
            throw new IOException("Source must not be null");
        }
        if (targetFile == null) {
            throw new IOException("Target must not be null");
        }
        if (!sourceFile.isFile() || !sourceFile.exists()) {
            throw new IOException("Source file '" + sourceFile.getAbsolutePath() + "' not found!");
        }
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                targetFile = new File(targetFile, sourceFile.getName());
            } else {
                if (!targetFile.isFile()) throw new IOException("Invalid target object '" + targetFile.getAbsolutePath() + "'!");
                if (!overwrite) {
                    throw new IOException("Target file '" + targetFile.getAbsolutePath() + "' already exists!");
                }
            }
        } else {
            FileUtils.forceMkdir((File)targetFile.getParentFile());
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(sourceFile);
            output = new FileOutputStream(targetFile);
            NioUtils.copy(input, output);
            output.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((OutputStream)output);
    }

    public static boolean create(File dest) {
        return NioUtils.create(dest, true, 1);
    }

    public static boolean create(File dest, boolean isFile, int retryTimes) {
        if (dest == null) {
            return false;
        }
        int totalRetry = retryTimes;
        if (retryTimes < 0) {
            totalRetry = 1;
        }
        int retry = 0;
        while (retry++ < totalRetry) {
            try {
                if (isFile) {
                    if (!dest.exists() && !dest.createNewFile()) continue;
                    return true;
                }
                FileUtils.forceMkdir((File)dest);
                return true;
            }
            catch (Exception ex) {
                int wait = (int)Math.pow(retry, retry) * 1000;
                int n = wait = wait < 1000 ? 1000 : wait;
                if (retry == totalRetry) {
                    return false;
                }
                logger.warn(String.format("[%s] create() - retry %s failed : wait [%s] ms , caused by %s", dest.getAbsolutePath(), retry, wait, ex.getMessage()));
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean delete(File dest) {
        return NioUtils.delete(dest, 1);
    }

    public static boolean delete(File dest, int retryTimes) {
        if (dest == null) {
            return false;
        }
        if (!dest.exists()) {
            return true;
        }
        int totalRetry = retryTimes;
        if (retryTimes < 1) {
            totalRetry = 1;
        }
        int retry = 0;
        while (retry++ < totalRetry) {
            try {
                FileUtils.forceDelete((File)dest);
                return true;
            }
            catch (FileNotFoundException ex) {
                return true;
            }
            catch (Exception ex) {
                int wait = (int)Math.pow(retry, retry) * 1000;
                int n = wait = wait < 1000 ? 1000 : wait;
                if (retry == totalRetry) {
                    try {
                        FileUtils.forceDeleteOnExit((File)dest);
                        return false;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                logger.warn(String.format("[%s] delete() - retry %s failed : wait [%s] ms , caused by %s", dest.getAbsolutePath(), retry, wait, ex.getMessage()));
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return false;
    }

    public static void move(File src, File dest) throws IOException {
        NioUtils.move(src, dest, 1);
    }

    public static void move(File src, File dest, int retryTimes) throws IOException {
        NioUtils.copy(src, dest, retryTimes);
        NioUtils.delete(src, retryTimes);
    }
}

