/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.shared.common.model.config.Transient;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JsonUtils {
    public static <T> T unmarshalFromByte(byte[] bytes, Class<T> targetClass) {
        return (T)JSON.parseObject((byte[])bytes, targetClass, (Feature[])new Feature[0]);
    }

    public static <T> T unmarshalFromByte(byte[] bytes, TypeReference<T> type) {
        return (T)JSON.parseObject((byte[])bytes, (Type)type.getType(), (Feature[])new Feature[0]);
    }

    public static byte[] marshalToByte(Object obj) {
        return JSON.toJSONBytes((Object)obj, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static byte[] marshalToByte(Object obj, SerializerFeature ... features) {
        return JSON.toJSONBytes((Object)obj, (SerializerFeature[])features);
    }

    public static <T> T unmarshalFromString(String json, Class<T> targetClass) {
        return (T)JSON.parseObject((String)json, targetClass);
    }

    public static <T> T unmarshalFromString(String json, TypeReference<T> type) {
        return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[0]);
    }

    public static String marshalToString(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String marshalToString(Object obj, SerializerFeature ... features) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])features);
    }

    public static String marshalToStringWithoutTransient(Object obj) {
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<String> transientFileds = new ArrayList<String>();
        for (Field f : fields) {
            Transient anno;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if ((anno = f.getAnnotation(Transient.class)) == null || !anno.value()) continue;
            transientFileds.add(f.getName());
        }
        return JsonUtils.marshalToString(obj, transientFileds.toArray(new String[transientFileds.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshalToString(Object obj, String ... fliterFields) {
        final List<String> propertyFliters = Arrays.asList(fliterFields);
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.getPropertyFilters().add(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return !propertyFliters.contains(name);
                }
            });
            serializer.write(obj);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    static {
        SerializeConfig.getGlobalInstance().put(InetAddress.class, (ObjectSerializer)InetAddressSerializer.instance);
        SerializeConfig.getGlobalInstance().put(Inet4Address.class, (ObjectSerializer)InetAddressSerializer.instance);
        SerializeConfig.getGlobalInstance().put(Inet6Address.class, (ObjectSerializer)InetAddressSerializer.instance);
        SerializeConfig.getGlobalInstance().put(InetSocketAddress.class, (ObjectSerializer)InetSocketAddressSerializer.instance);
        ParserConfig.getGlobalInstance().getDeserializers().put(InetAddress.class, (Object)InetSocketAddressSerializer.InetAddressDeserializer.instance);
        ParserConfig.getGlobalInstance().getDeserializers().put(Inet4Address.class, (Object)InetSocketAddressSerializer.InetAddressDeserializer.instance);
        ParserConfig.getGlobalInstance().getDeserializers().put(Inet6Address.class, (Object)InetSocketAddressSerializer.InetAddressDeserializer.instance);
        ParserConfig.getGlobalInstance().getDeserializers().put(InetSocketAddress.class, (Object)InetSocketAddressSerializer.InetSocketAddressDeserializer.instance);
        SerializeConfig.getGlobalInstance().put(Inet6Address.class, (ObjectSerializer)InetAddressSerializer.instance);
        ParserConfig.getGlobalInstance().addAccept("com.alibaba.otter.");
        ParserConfig.getGlobalInstance().addAccept("com.taobao.tddl.dbsync.");
    }

    public static class InetSocketAddressSerializer
    implements ObjectSerializer {
        public static InetSocketAddressSerializer instance = new InetSocketAddressSerializer();

        public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            SerializeWriter out = serializer.out;
            InetSocketAddress address = (InetSocketAddress)object;
            InetAddress inetAddress = address.getAddress();
            serializer.write((Object)Character.valueOf('{'));
            out.writeFieldName("address");
            if (inetAddress != null) {
                serializer.write((Object)inetAddress);
            } else {
                out.writeString(address.getHostString());
            }
            out.write(44);
            out.writeFieldName("port");
            out.writeInt(address.getPort());
            serializer.write((Object)Character.valueOf('}'));
        }

        public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            SerializeWriter out = serializer.out;
            InetSocketAddress address = (InetSocketAddress)object;
            address.getHostString();
            InetAddress inetAddress = address.getAddress();
            out.write(123);
            out.writeFieldName("address");
            if (inetAddress != null) {
                serializer.write((Object)inetAddress);
            } else {
                out.writeString(address.getHostString());
            }
            out.write(44);
            out.writeFieldName("port");
            out.writeInt(address.getPort());
            out.write(125);
        }

        public static class InetSocketAddressDeserializer
        implements ObjectDeserializer {
            public static InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

            public InetSocketAddress deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
                JSONLexer lexer = parser.lexer;
                if (lexer.token() == 8) {
                    lexer.nextToken();
                    return null;
                }
                parser.accept(12);
                Object address = null;
                int port = 0;
                while (true) {
                    String key = lexer.stringVal();
                    lexer.nextToken(17);
                    if (key.equals("address")) {
                        parser.accept(17);
                        address = parser.parseObject(InetAddress.class);
                    } else if (key.equals("port")) {
                        parser.accept(17);
                        if (lexer.token() != 2) {
                            throw new RuntimeException("port is not int");
                        }
                        port = lexer.intValue();
                        lexer.nextToken();
                    } else {
                        parser.accept(17);
                        parser.parse();
                    }
                    if (lexer.token() != 16) break;
                    lexer.nextToken();
                }
                parser.accept(13);
                return new InetSocketAddress(address.toString(), port);
            }

            public int getFastMatchToken() {
                return 0;
            }
        }

        public static class InetAddressDeserializer
        implements ObjectDeserializer {
            public static InetAddressDeserializer instance = new InetAddressDeserializer();

            public String deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
                return (String)parser.parse();
            }

            public int getFastMatchToken() {
                return 0;
            }
        }
    }

    public static class InetAddressSerializer
    implements ObjectSerializer {
        public static InetAddressSerializer instance = new InetAddressSerializer();

        public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            InetAddress address = (InetAddress)object;
            String[] data = StringUtils.split((String)address.toString(), (char)'/');
            serializer.write(data[0]);
        }

        public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            InetAddress address = (InetAddress)object;
            String[] data = StringUtils.split((String)address.toString(), (char)'/');
            serializer.write(data[0]);
        }
    }
}

