/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.utils;

public final class Assert {
    public static <T> T assertNotNull(T object) {
        return Assert.assertNotNull(object, null, null, (Object[])null);
    }

    public static <T> T assertNotNull(T object, String message, Object ... args) {
        return Assert.assertNotNull(object, null, message, args);
    }

    public static <T> T assertNotNull(T object, ExceptionType exceptionType, String message, Object ... args) {
        if (object == null) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the argument is required; it must not be null"));
        }
        return object;
    }

    public static <T> T assertNull(T object) {
        return Assert.assertNull(object, null, null, (Object[])null);
    }

    public static <T> T assertNull(T object, String message, Object ... args) {
        return Assert.assertNull(object, null, message, args);
    }

    public static <T> T assertNull(T object, ExceptionType exceptionType, String message, Object ... args) {
        if (object != null) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the object argument must be null"));
        }
        return object;
    }

    public static void assertTrue(boolean expression) {
        Assert.assertTrue(expression, null, null, (Object[])null);
    }

    public static void assertTrue(boolean expression, String message, Object ... args) {
        Assert.assertTrue(expression, null, message, args);
    }

    public static void assertTrue(boolean expression, ExceptionType exceptionType, String message, Object ... args) {
        if (!expression) {
            if (exceptionType == null) {
                exceptionType = ExceptionType.ILLEGAL_ARGUMENT;
            }
            throw exceptionType.newInstance(Assert.getMessage(message, args, "[Assertion failed] - the expression must be true"));
        }
    }

    private static String getMessage(String message, Object[] args, String defaultMessage) {
        if (message == null) {
            message = defaultMessage;
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return String.format(message, args);
    }

    public static enum ExceptionType {
        ILLEGAL_ARGUMENT{

            @Override
            RuntimeException newInstance(String message) {
                return new IllegalArgumentException(message);
            }
        };


        abstract RuntimeException newInstance(String var1);
    }
}

