/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.model.config.parameter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = -8019445081834822960L;
    private Map<String, String> params = new ConcurrentHashMap<String, String>(10);
    private boolean mergeSystemProperties = true;

    public Object put(String key, String value) {
        return this.params.put(key, value);
    }

    public String getString(String key) {
        String value = this.params.get(key);
        return this.mergeSystemProperties && value == null ? System.getProperty(key) : null;
    }

    public Integer getInteger(String key) {
        String value = this.getString(key);
        return value == null ? null : Integer.valueOf(value);
    }

    public Long getLong(String key) {
        String value = this.getString(key);
        return value == null ? null : Long.valueOf(value);
    }

    public BigDecimal getBigDecimal(String key) {
        String value = this.getString(key);
        return value == null ? null : new BigDecimal(value);
    }

    public Boolean getBool(String key) {
        String value = this.getString(key);
        return value == null ? null : Boolean.valueOf(value);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType) {
        String value = this.getString(key);
        return Enum.valueOf(enumType, value);
    }

    protected void setParams(Map params) {
        params.putAll(params);
    }

    protected Map getParams() {
        return this.params;
    }
}

