/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.model.config.data;

import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.utils.OtterToStringStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.util.Assert;

public class DataMedia<Source extends DataMediaSource>
implements Serializable {
    private static final long serialVersionUID = -7161158767271516776L;
    private Long id;
    private String namespace;
    private String name;
    private Source source;
    private String encode;
    private Date gmtCreate;
    private Date gmtModified;
    private transient ModeValue nameMode;
    private transient ModeValue namespaceMode;
    @Deprecated
    private Mode mode;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public Mode getMode() {
        if (this.mode == null) {
            this.mode = ConfigHelper.parseMode(this.namespace).getMode();
        }
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public ModeValue getNameMode() {
        if (this.nameMode == null) {
            this.nameMode = ConfigHelper.parseMode(this.name);
        }
        return this.nameMode;
    }

    public void setNameMode(ModeValue nameMode) {
        this.nameMode = nameMode;
    }

    public ModeValue getNamespaceMode() {
        if (this.namespaceMode == null) {
            this.namespaceMode = ConfigHelper.parseMode(this.namespace);
        }
        return this.namespaceMode;
    }

    public void setNamespaceMode(ModeValue namespaceMode) {
        this.namespaceMode = namespaceMode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)OtterToStringStyle.DEFAULT_STYLE);
    }

    public static class ModeValue
    implements Serializable {
        private static final long serialVersionUID = 54902778821522113L;
        private Mode mode;
        private List<String> values = new ArrayList<String>();

        public ModeValue(Mode mode, List<String> values) {
            this.mode = mode;
            this.values = values;
        }

        public String getSingleValue() {
            Assert.notEmpty(this.values);
            return this.values.get(0);
        }

        public List<String> getMultiValue() {
            return this.values;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)OtterToStringStyle.DEFAULT_STYLE);
        }
    }

    public static enum Mode {
        SINGLE(0),
        MULTI(1),
        WILDCARD(3);

        private int value;

        private Mode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isSingle() {
            return this == SINGLE;
        }

        public boolean isMulti() {
            return this == MULTI;
        }

        public boolean isWildCard() {
            return this == WILDCARD;
        }
    }
}

