/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.model.config.channel;

import com.alibaba.otter.shared.common.model.config.ConfigException;
import com.alibaba.otter.shared.common.utils.OtterToStringStyle;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ChannelParameter
implements Serializable {
    private static final long serialVersionUID = 298053781205276645L;
    private Long channelId;
    private boolean enableRemedy = false;
    private RemedyAlgorithm remedyAlgorithm = RemedyAlgorithm.LOOPBACK;
    private int remedyDelayThresoldForMedia = 60;
    private SyncMode syncMode = SyncMode.FIELD;
    private SyncConsistency syncConsistency = SyncConsistency.BASE;

    public boolean isEnableRemedy() {
        return this.enableRemedy;
    }

    public void setEnableRemedy(boolean enableRemedy) {
        this.enableRemedy = enableRemedy;
    }

    public int getRemedyDelayThresoldForMedia() {
        return this.remedyDelayThresoldForMedia <= 0 ? 10 : this.remedyDelayThresoldForMedia;
    }

    public void setRemedyDelayThresoldForMedia(int remedyDelayThresoldForMedia) {
        this.remedyDelayThresoldForMedia = remedyDelayThresoldForMedia;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public SyncMode getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    public SyncConsistency getSyncConsistency() {
        return this.syncConsistency;
    }

    public void setSyncConsistency(SyncConsistency syncConsistency) {
        this.syncConsistency = syncConsistency;
    }

    public RemedyAlgorithm getRemedyAlgorithm() {
        return this.remedyAlgorithm == null ? RemedyAlgorithm.LOOPBACK : this.remedyAlgorithm;
    }

    public void setRemedyAlgorithm(RemedyAlgorithm remedyAlgorithm) {
        this.remedyAlgorithm = remedyAlgorithm;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)OtterToStringStyle.DEFAULT_STYLE);
    }

    public static enum SyncConsistency {
        MEDIA("M"),
        STORE("S"),
        BASE("B");

        private String value;

        private SyncConsistency(String value) {
            this.value = value;
        }

        public static SyncConsistency valuesOf(String value) {
            SyncConsistency[] modes;
            for (SyncConsistency mode : modes = SyncConsistency.values()) {
                if (!mode.value.equalsIgnoreCase(value)) continue;
                return mode;
            }
            throw new ConfigException("unknow SyncConsistency : " + value);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isMedia() {
            return this.equals((Object)MEDIA);
        }

        public boolean isStore() {
            return this.equals((Object)STORE);
        }

        public boolean isBase() {
            return this.equals((Object)BASE);
        }
    }

    public static enum SyncMode {
        ROW("R"),
        FIELD("F");

        private String value;

        private SyncMode(String value) {
            this.value = value;
        }

        public static SyncMode valuesOf(String value) {
            SyncMode[] modes;
            for (SyncMode mode : modes = SyncMode.values()) {
                if (!mode.value.equalsIgnoreCase(value)) continue;
                return mode;
            }
            throw new ConfigException("unknow SyncMode : " + value);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isRow() {
            return this.equals((Object)ROW);
        }

        public boolean isField() {
            return this.equals((Object)FIELD);
        }
    }

    public static enum RemedyAlgorithm {
        INTERSECTION,
        LOOPBACK;


        public boolean isIntersection() {
            return this.equals((Object)INTERSECTION);
        }

        public boolean isLoopback() {
            return this.equals((Object)LOOPBACK);
        }
    }
}

