/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.common.model.config;

import com.alibaba.otter.shared.common.model.config.ConfigException;
import com.alibaba.otter.shared.common.model.config.ModeValueFilter;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.util.Assert;

public class ConfigHelper {
    public static final String MODE_PATTERN = "(.*)(\\[(\\d+)\\-(\\d+)\\])(.*)";
    private static Map<String, Pattern> patterns = OtterMigrateMap.makeComputingMap(new Function<String, Pattern>(){

        public Pattern apply(String input) {
            Perl5Compiler pc = new Perl5Compiler();
            try {
                return pc.compile(input, 32769);
            }
            catch (MalformedPatternException e) {
                throw new ConfigException(e);
            }
        }
    });

    public static DataMedia<? extends DataMediaSource> findDataMedia(Pipeline pipeline, Long id) {
        Assert.notNull((Object)pipeline);
        for (DataMediaPair pair : pipeline.getPairs()) {
            if (pair.getSource().getId().equals(id)) {
                return pair.getSource();
            }
            if (!pair.getTarget().getId().equals(id)) continue;
            return pair.getTarget();
        }
        throw new ConfigException("no such DataMedia , the tableId = " + id);
    }

    public static DataMedia<? extends DataMediaSource> findSourceDataMedia(Pipeline pipeline, String namespace, String name) {
        return ConfigHelper.findSourceDataMedia(pipeline, namespace, name, false);
    }

    public static DataMedia<? extends DataMediaSource> findSourceDataMedia(Pipeline pipeline, String namespace, String name, boolean notExistReturnNull) {
        for (DataMediaPair pair : pipeline.getPairs()) {
            if (!ConfigHelper.isMatch(pair.getSource(), namespace, name)) continue;
            return pair.getSource();
        }
        if (notExistReturnNull) {
            return null;
        }
        throw new ConfigException("no such DataMedia , the namespace = " + namespace + " name = " + name);
    }

    public static DataMediaPair findDataMediaPairBySourceName(Pipeline pipeline, String namespace, String name) {
        return ConfigHelper.findDataMediaPairBySourceName(pipeline, namespace, name, false);
    }

    public static DataMediaPair findDataMediaPairBySourceName(Pipeline pipeline, String namespace, String name, boolean notExistReturnNull) {
        for (DataMediaPair pair : pipeline.getPairs()) {
            if (!ConfigHelper.isMatch(pair.getSource(), namespace, name)) continue;
            return pair;
        }
        if (notExistReturnNull) {
            return null;
        }
        throw new ConfigException("no such DataMedia , the namespace = " + namespace + " name = " + name);
    }

    public static List<DataMediaPair> findDataMediaPairByMediaId(Pipeline pipeline, Long tid) {
        Assert.notNull((Object)pipeline);
        ArrayList<DataMediaPair> pairs = new ArrayList<DataMediaPair>();
        for (DataMediaPair pair : pipeline.getPairs()) {
            if (pair.getSource().getId().equals(tid)) {
                pairs.add(pair);
                continue;
            }
            if (!pair.getTarget().getId().equals(tid)) continue;
            pairs.add(pair);
        }
        return pairs;
    }

    public static DataMediaPair findDataMediaPair(Pipeline pipeline, Long pairId) {
        Assert.notNull((Object)pipeline);
        for (DataMediaPair pair : pipeline.getPairs()) {
            if (!pair.getId().equals(pairId)) continue;
            return pair;
        }
        throw new ConfigException("no such DataMediaPair , the pairId = " + pairId);
    }

    public static DataMedia.ModeValue parseMode(String value) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.matches(value, patterns.get(MODE_PATTERN))) {
            MatchResult matchResult = matcher.getMatch();
            String prefix = matchResult.group(1);
            String startStr = matchResult.group(3);
            String ednStr = matchResult.group(4);
            int start = Integer.valueOf(startStr);
            int end = Integer.valueOf(ednStr);
            String postfix = matchResult.group(5);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = start; i <= end; ++i) {
                StringBuilder builder = new StringBuilder(value.length());
                String str = String.valueOf(i);
                if (startStr.length() == ednStr.length() && startStr.startsWith("0")) {
                    str = StringUtils.leftPad((String)String.valueOf(i), (int)startStr.length(), (char)'0');
                }
                builder.append(prefix).append(str).append(postfix);
                values.add(builder.toString());
            }
            return new DataMedia.ModeValue(DataMedia.Mode.MULTI, values);
        }
        if (ConfigHelper.isWildCard(value)) {
            return new DataMedia.ModeValue(DataMedia.Mode.WILDCARD, Arrays.asList(value));
        }
        return new DataMedia.ModeValue(DataMedia.Mode.SINGLE, Arrays.asList(value));
    }

    public static String makeSQLPattern(String rawValue) {
        return ConfigHelper.makeSQLPattern(ConfigHelper.parseMode(rawValue), rawValue);
    }

    public static String makeSQLPattern(DataMedia.ModeValue mode, String rawValue) {
        Assert.notNull((Object)mode);
        Assert.notNull((Object)rawValue);
        if (mode.getMode().isSingle()) {
            return rawValue;
        }
        if (mode.getMode().isMulti()) {
            return StringUtils.substringBefore((String)rawValue, (String)"[") + "%";
        }
        if (mode.getMode().isWildCard()) {
            String charString;
            StringBuilder sb = new StringBuilder(rawValue.length());
            for (int i = 0; i < rawValue.length() && !ConfigHelper.isWildCard(charString = String.valueOf(rawValue.charAt(i))); ++i) {
                sb.append(rawValue.charAt(i));
            }
            return sb.toString() + "%";
        }
        throw new UnsupportedOperationException("unsupport mode:" + (Object)((Object)mode.getMode()));
    }

    public static ModeValueFilter makeModeValueFilter(final DataMedia.ModeValue mode, final String rawValue) {
        Assert.notNull((Object)mode);
        Assert.notNull((Object)rawValue);
        if (mode.getMode().isSingle()) {
            return new ModeValueFilter(){

                @Override
                public boolean accept(String value) {
                    return rawValue.equalsIgnoreCase(value);
                }
            };
        }
        if (mode.getMode().isWildCard()) {
            return new ModeValueFilter(){

                @Override
                public boolean accept(String value) {
                    return ConfigHelper.isWildCardMatch(rawValue, value);
                }
            };
        }
        if (mode.getMode().isMulti()) {
            return new ModeValueFilter(){

                @Override
                public boolean accept(String value) {
                    return ConfigHelper.indexIgnoreCase(mode.getMultiValue(), value) != -1;
                }
            };
        }
        throw new UnsupportedOperationException("unsupport mode:" + (Object)((Object)mode.getMode()));
    }

    private static boolean isMatch(DataMedia dataMedia, String namespace, String name) {
        boolean isMatch = true;
        if (StringUtils.isEmpty((String)namespace)) {
            isMatch &= StringUtils.isEmpty((String)dataMedia.getNamespace());
        } else if (dataMedia.getNamespaceMode().getMode().isSingle()) {
            isMatch &= dataMedia.getNamespace().equalsIgnoreCase(namespace);
        } else if (dataMedia.getNamespaceMode().getMode().isMulti()) {
            isMatch &= ConfigHelper.indexIgnoreCase(dataMedia.getNamespaceMode().getMultiValue(), namespace) != -1;
        } else if (dataMedia.getNamespaceMode().getMode().isWildCard()) {
            isMatch &= ConfigHelper.isWildCardMatch(dataMedia.getNamespace(), namespace);
        } else {
            throw new UnsupportedOperationException("unsupport mode:" + (Object)((Object)dataMedia.getNameMode().getMode()));
        }
        if (StringUtils.isEmpty((String)name)) {
            isMatch &= StringUtils.isEmpty((String)dataMedia.getName());
        } else if (dataMedia.getNameMode().getMode().isSingle()) {
            isMatch &= dataMedia.getName().equalsIgnoreCase(name);
        } else if (dataMedia.getNameMode().getMode().isMulti()) {
            isMatch &= ConfigHelper.indexIgnoreCase(dataMedia.getNameMode().getMultiValue(), name) != -1;
        } else if (dataMedia.getNameMode().getMode().isWildCard()) {
            isMatch &= ConfigHelper.isWildCardMatch(dataMedia.getName(), name);
        } else {
            throw new UnsupportedOperationException("unsupport mode:" + (Object)((Object)dataMedia.getNameMode().getMode()));
        }
        return isMatch;
    }

    private static boolean isWildCard(String value) {
        return StringUtils.containsAny((String)value, (char[])new char[]{'*', '?', '+', '|', '(', ')', '{', '}', '[', ']', '\\', '$', '^', '.'});
    }

    private static boolean isWildCardMatch(String matchPattern, String value) {
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.matches(value, patterns.get(matchPattern));
    }

    public static int indexIgnoreCase(List<String> datas, String value) {
        for (int i = 0; i < datas.size(); ++i) {
            String data = datas.get(i);
            if (!data.equalsIgnoreCase(value)) continue;
            return i;
        }
        return -1;
    }
}

