/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.model;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.model.EventData;
import org.apache.commons.lang.StringUtils;

public class RemedyIndexEventData
extends EventData {
    private static final String SPLIT = "_";
    private static final long serialVersionUID = 3125886367323255220L;
    private Long pipelineId;
    private Long processId;
    private Long startTime;
    private Long endTime;

    public Long getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(Long pipelineId) {
        this.pipelineId = pipelineId;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public static String formatNodeName(RemedyIndexEventData eventData) {
        StringBuilder builder = new StringBuilder();
        builder.append(eventData.getProcessId()).append(SPLIT).append(eventData.getStartTime()).append(SPLIT).append(eventData.getEndTime());
        return builder.toString();
    }

    public static RemedyIndexEventData parseNodeName(String node) {
        String[] datas = StringUtils.split((String)node, (String)SPLIT);
        if (datas.length != 3) {
            throw new ArbitrateException("remedy index[" + node + "] format is not correctly!");
        }
        RemedyIndexEventData eventData = new RemedyIndexEventData();
        eventData.setProcessId(Long.valueOf(datas[0]));
        eventData.setStartTime(Long.valueOf(datas[1]));
        eventData.setEndTime(Long.valueOf(datas[2]));
        return eventData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.pipelineId == null ? 0 : this.pipelineId.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemedyIndexEventData)) {
            return false;
        }
        RemedyIndexEventData other = (RemedyIndexEventData)obj;
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.pipelineId == null ? other.pipelineId != null : !this.pipelineId.equals(other.pipelineId)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }
}

