/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock;

import org.springframework.util.Assert;

public class LockNode
implements Comparable<LockNode> {
    private final String name;
    private String prefix;
    private int sequence = -1;

    public LockNode(String name) {
        Assert.notNull((Object)name, (String)"id cannot be null");
        this.name = name;
        this.prefix = name;
        int idx = name.lastIndexOf(45);
        if (idx >= 0) {
            this.prefix = name.substring(0, idx);
            try {
                this.sequence = Integer.parseInt(name.substring(idx + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(LockNode that) {
        int s1 = this.sequence;
        int s2 = that.sequence;
        if (s1 == -1 && s2 == -1) {
            return this.name.compareTo(that.name);
        }
        if (s1 == -1) {
            return -1;
        }
        if (s2 == -1) {
            return 1;
        }
        return s1 - s2;
    }

    public String getName() {
        return this.name;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.name.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockNode other = (LockNode)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

