/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock;

import com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock.DistributedLock;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.KeeperException;

public class DistributedReentrantLock
extends DistributedLock {
    private static final String ID_FORMAT = "Thread[{0}] Distributed[{1}]";
    private ReentrantLock reentrantLock = new ReentrantLock();

    public DistributedReentrantLock(String root) {
        super(root);
    }

    @Override
    public void lock() throws InterruptedException, KeeperException {
        this.reentrantLock.lock();
        super.lock();
    }

    @Override
    public boolean tryLock() throws KeeperException {
        return this.reentrantLock.tryLock() && super.tryLock();
    }

    @Override
    public void unlock() throws KeeperException {
        super.unlock();
        this.reentrantLock.unlock();
    }

    @Override
    public String getId() {
        return MessageFormat.format(ID_FORMAT, Thread.currentThread().getId(), super.getId());
    }

    @Override
    public boolean isOwner() {
        return this.reentrantLock.isHeldByCurrentThread() && super.isOwner();
    }
}

