/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock;

import com.alibaba.otter.shared.arbitrate.impl.zookeeper.AsyncWatcher;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock.LockNode;
import com.alibaba.otter.shared.common.utils.lock.BooleanMutex;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import com.alibaba.otter.shared.common.utils.zookeeper.ZooKeeperx;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLock {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLock.class);
    private static final byte[] data = new byte[]{18, 52};
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private final String root;
    private String id;
    private LockNode idName;
    private String ownerId;
    private String lastChildId;
    private Throwable other = null;
    private KeeperException exception = null;
    private InterruptedException interrupt = null;

    public DistributedLock(String root) {
        this.root = root;
        this.ensureExists(root);
    }

    public void lock() throws InterruptedException, KeeperException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.interrupt != null) {
            throw this.interrupt;
        }
        if (this.other != null) {
            throw new NestableRuntimeException(this.other);
        }
        if (this.isOwner()) {
            return;
        }
        BooleanMutex mutex = new BooleanMutex();
        this.acquireLock(mutex);
        mutex.get();
        if (this.exception != null) {
            this.unlock();
            throw this.exception;
        }
        if (this.interrupt != null) {
            this.unlock();
            throw this.interrupt;
        }
        if (this.other != null) {
            this.unlock();
            throw new NestableRuntimeException(this.other);
        }
    }

    public boolean tryLock() throws KeeperException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.isOwner()) {
            return true;
        }
        this.acquireLock(null);
        if (this.exception != null) {
            this.unlock();
            throw this.exception;
        }
        if (this.interrupt != null) {
            this.unlock();
            Thread.currentThread().interrupt();
        }
        if (this.other != null) {
            this.unlock();
            throw new NestableRuntimeException(this.other);
        }
        return this.isOwner();
    }

    public void unlock() throws KeeperException {
        if (this.id != null) {
            this.zookeeper.delete(this.root + "/" + this.id);
            this.id = null;
            this.idName = null;
        }
    }

    private void ensureExists(String path) {
        try {
            if (this.zookeeper.exists(path)) {
                return;
            }
            this.zookeeper.create(path, (Object)data, CreateMode.PERSISTENT);
        }
        catch (ZkInterruptedException e) {
            Thread.currentThread().interrupt();
            this.interrupt = (InterruptedException)e.getCause();
        }
        catch (ZkException e) {
            this.exception = (KeeperException)e.getCause();
        }
    }

    public String getRoot() {
        return this.root;
    }

    public boolean isOwner() {
        return this.id != null && this.ownerId != null && this.id.equals(this.ownerId);
    }

    public String getId() {
        return this.id;
    }

    private Boolean acquireLock(final BooleanMutex mutex) {
        block16: {
            try {
                do {
                    if (this.id == null) {
                        long sessionId = this.getSessionId();
                        String prefix = "x-" + sessionId + "-";
                        String path = this.zookeeper.create(this.root + "/" + (String)prefix, (Object)data, CreateMode.EPHEMERAL_SEQUENTIAL);
                        int index = path.lastIndexOf("/");
                        this.id = StringUtils.substring((String)path, (int)(index + 1));
                        this.idName = new LockNode(this.id);
                    }
                    if (this.id == null) continue;
                    List names = this.zookeeper.getChildren(this.root);
                    if (names.isEmpty()) {
                        logger.warn("lock lost with scene:empty list, id[] and node[]", (Object)this.id, (Object)this.idName);
                        this.unlock();
                        continue;
                    }
                    TreeSet<LockNode> sortedNames = new TreeSet<LockNode>();
                    for (String name : names) {
                        sortedNames.add(new LockNode(name));
                    }
                    if (!sortedNames.contains(this.idName)) {
                        logger.warn("lock lost with scene:not contains ,id[] and node[]", (Object)this.id, (Object)this.idName);
                        this.unlock();
                        continue;
                    }
                    this.ownerId = ((LockNode)sortedNames.first()).getName();
                    if (mutex != null && this.isOwner()) {
                        mutex.set(Boolean.valueOf(true));
                        return true;
                    }
                    if (mutex == null) {
                        return this.isOwner();
                    }
                    SortedSet<LockNode> lessThanMe = sortedNames.headSet(this.idName);
                    if (!lessThanMe.isEmpty()) {
                        LockNode lastChildName = lessThanMe.last();
                        this.lastChildId = lastChildName.getName();
                        IZkConnection connection = this.zookeeper.getConnection();
                        ZooKeeper orginZk = ((ZooKeeperx)connection).getZookeeper();
                        Stat stat = orginZk.exists(this.root + "/" + this.lastChildId, (Watcher)new AsyncWatcher(){

                            @Override
                            public void asyncProcess(WatchedEvent event) {
                                if (!mutex.state()) {
                                    DistributedLock.this.acquireLock(mutex);
                                } else {
                                    logger.warn("locked successful.");
                                }
                            }
                        });
                        if (stat != null) continue;
                        this.acquireLock(mutex);
                        continue;
                    }
                    if (this.isOwner()) {
                        mutex.set(Boolean.valueOf(true));
                        continue;
                    }
                    logger.warn("lock lost with scene:no less ,id[] and node[]", (Object)this.id, (Object)this.idName);
                    this.unlock();
                } while (this.id == null);
            }
            catch (KeeperException e) {
                this.exception = e;
                if (mutex != null) {
                    mutex.set(Boolean.valueOf(true));
                }
            }
            catch (InterruptedException e) {
                this.interrupt = e;
                if (mutex != null) {
                    mutex.set(Boolean.valueOf(true));
                }
            }
            catch (Throwable e) {
                this.other = e;
                if (mutex == null) break block16;
                mutex.set(Boolean.valueOf(true));
            }
        }
        if (this.isOwner() && mutex != null) {
            mutex.set(Boolean.valueOf(true));
        }
        return Boolean.FALSE;
    }

    private long getSessionId() {
        IZkConnection connection = this.zookeeper.getConnection();
        return ((ZooKeeperx)connection).getZookeeper().getSessionId();
    }
}

