/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperOperation;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ZooKeeperx {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperx.class);
    private static final Integer maxRetry = 3;
    private long retryDelay = 3000L;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private ZooKeeper zookeeper;
    private AtomicInteger cversion = new AtomicInteger(0);
    private AtomicBoolean running = new AtomicBoolean(true);

    public ZooKeeperx(ZooKeeper zookeeper) {
        this.zookeeper = zookeeper;
    }

    public String createNoRetry(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this.zookeeper.create(path, data, this.acl, mode);
    }

    public String create(final String path, final byte[] data, final CreateMode mode) throws KeeperException, InterruptedException {
        if (mode.isSequential()) {
            return this.zookeeper.create(path, data, this.acl, mode);
        }
        return this.retryOperation(new ZooKeeperOperation<String>(){

            @Override
            public String execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.create(path, data, ZooKeeperx.this.acl, mode);
            }
        });
    }

    public void delete(final String path, final int version) throws InterruptedException, KeeperException {
        this.retryOperation(new ZooKeeperOperation(){

            public Object execute() throws KeeperException, InterruptedException {
                ZooKeeperx.this.zookeeper.delete(path, version);
                return null;
            }
        });
    }

    public void delete(final String path, final int version, final AsyncCallback.VoidCallback cb, final Object ctx) throws InterruptedException, KeeperException {
        this.retryOperation(new ZooKeeperOperation(){

            public Object execute() throws KeeperException, InterruptedException {
                ZooKeeperx.this.zookeeper.delete(path, version, cb, ctx);
                return null;
            }
        });
    }

    public Stat exists(final String path, final boolean watch) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<Stat>(){

            @Override
            public Stat execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.exists(path, watch);
            }
        });
    }

    public Stat exists(final String path, final Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<Stat>(){

            @Override
            public Stat execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.exists(path, watcher);
            }
        });
    }

    public List<String> getChildren(final String path, final boolean watch) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.getChildren(path, watch);
            }
        });
    }

    public List<String> getChildren(final String path, final boolean watch, final Stat stat) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.getChildren(path, watch, stat);
            }
        });
    }

    public List<String> getChildren(final String path, final Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.getChildren(path, watcher);
            }
        });
    }

    public byte[] getData(final String path, final boolean watch, final Stat stat) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<byte[]>(){

            @Override
            public byte[] execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.getData(path, watch, stat);
            }
        });
    }

    public byte[] getData(final String path, final Watcher watcher, final Stat stat) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<byte[]>(){

            @Override
            public byte[] execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.getData(path, watcher, stat);
            }
        });
    }

    public Stat setData(final String path, final byte[] data, final int version) throws KeeperException, InterruptedException {
        return this.retryOperation(new ZooKeeperOperation<Stat>(){

            @Override
            public Stat execute() throws KeeperException, InterruptedException {
                return ZooKeeperx.this.zookeeper.setData(path, data, version);
            }
        });
    }

    public <T> T retryOperation(ZooKeeperOperation<T> operation) throws KeeperException, InterruptedException {
        if (!this.running.get()) {
            throw new ArbitrateException("Zookeeper is destory ,should never be used ....");
        }
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < maxRetry; ++i) {
            int version = this.cversion.get();
            int retryCount = i + 1;
            try {
                if (this.zookeeper.getState().isAlive()) {
                    return operation.execute();
                }
                this.retryDelay(retryCount);
                this.cleanup(version);
                continue;
            }
            catch (KeeperException.SessionExpiredException e) {
                logger.warn("Session expired for: " + this + " so reconnecting " + (i + 1) + " times due to: " + (Object)((Object)e), (Throwable)e);
                this.retryDelay(retryCount);
                this.cleanup(version);
                continue;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                logger.warn("Attempt " + retryCount + " failed with connection loss so attempting to reconnect: " + (Object)((Object)e), (Throwable)e);
                this.retryDelay(retryCount);
            }
        }
        throw exception;
    }

    private void retryDelay(int attemptCount) {
        if (attemptCount > 0) {
            try {
                Thread.sleep((long)attemptCount * this.retryDelay);
            }
            catch (InterruptedException e) {
                logger.warn("Failed to sleep: " + e, (Throwable)e);
            }
        }
    }

    public ZooKeeper getDelegate() {
        return this.zookeeper;
    }

    private synchronized void cleanup(int version) {
    }

    public void destory() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.zookeeper.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }
}

