/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper;

import com.alibaba.otter.shared.arbitrate.impl.manage.NodeArbitrateEvent;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ZooKeeperHeartBeatWorker
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperHeartBeatWorker.class);
    private int period = 3000;
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Otter-zookeeper-heartbeat"), new ThreadPoolExecutor.CallerRunsPolicy());
    private NodeArbitrateEvent nodeEvent;

    public void start() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ZooKeeperHeartBeatWorker.this.nodeEvent.liveNodes();
                }
                catch (Throwable e) {
                    logger.warn("zookeeper heartbeat has failed.", e);
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.scheduler.shutdownNow();
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setNodeEvent(NodeArbitrateEvent nodeEvent) {
        this.nodeEvent = nodeEvent;
    }
}

