/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.zookeeper;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.SessionExpiredNotification;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.IZkStateListener;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.Watcher;

public class ZooKeeperClient {
    private static String cluster;
    private static int sessionTimeout;
    private static Map<Long, ZkClientx> clients;
    private static Long defaultId;

    public static ZkClientx getInstance() {
        return ZooKeeperClient.getInstance(defaultId);
    }

    public static ZkClientx getInstance(Long pipelineId) {
        return clients.get(pipelineId);
    }

    public static void destory() {
        for (ZkClientx zkClient : clients.values()) {
            zkClient.close();
        }
    }

    public static void registerNotification(final SessionExpiredNotification notification) {
        ZooKeeperClient.getInstance().subscribeStateChanges(new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
            }

            public void handleNewSession() throws Exception {
                notification.notification();
            }

            public void handleSessionEstablishmentError(Throwable error) throws Exception {
            }
        });
    }

    private static ZkClientx createClient() {
        List<String> serveraddrs = ZooKeeperClient.getServerAddrs();
        return new ZkClientx(StringUtils.join(serveraddrs, (String)","), sessionTimeout);
    }

    private static List<String> getServerAddrs() {
        List<String> result = ArbitrateConfigUtils.getServerAddrs();
        if (result == null || result.size() == 0) {
            result = Arrays.asList(cluster);
        }
        return result;
    }

    public void setCluster(String cluster) {
        ZooKeeperClient.cluster = cluster;
    }

    public void setSessionTimeout(int timeout) {
        sessionTimeout = timeout;
    }

    static {
        sessionTimeout = 10000;
        clients = OtterMigrateMap.makeComputingMap((Function)new Function<Long, ZkClientx>(){

            public ZkClientx apply(Long pipelineId) {
                return ZooKeeperClient.createClient();
            }
        });
        defaultId = 0L;
    }
}

