/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StageComparator;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin.TerminProcess;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.ProcessNodeEventData;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.zookeeper.CreateMode;
import org.springframework.util.CollectionUtils;

public class NormalTerminProcess
implements TerminProcess {
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    @Override
    public boolean process(TerminEventData data) {
        return this.doProcess(data, false);
    }

    private boolean doProcess(TerminEventData data, boolean retry) {
        boolean successed;
        Long pipelineId = data.getPipelineId();
        Long processId = data.getProcessId();
        List currentStages = null;
        try {
            currentStages = this.zookeeper.getChildren(StagePathUtils.getProcess(pipelineId, processId));
            Collections.sort(currentStages, new StageComparator());
        }
        catch (ZkNoNodeException e) {
            return false;
        }
        catch (ZkException e) {
            throw new ArbitrateException("Termin_process", e);
        }
        if (currentStages == null || currentStages.contains("selected")) {
            try {
                successed = this.zookeeper.delete(StagePathUtils.getSelectStage(pipelineId, processId));
                if (!successed) {
                    this.processDeleteFailed();
                }
            }
            catch (ZkException e) {
                throw new ArbitrateException("Termin_process", e);
            }
        }
        if (currentStages == null || currentStages.contains("extracted")) {
            try {
                successed = this.zookeeper.delete(StagePathUtils.getExtractStage(pipelineId, processId));
                if (!successed) {
                    this.processDeleteFailed();
                }
            }
            catch (ZkException e) {
                throw new ArbitrateException("Termin_process", e);
            }
        }
        if (currentStages == null || currentStages.contains("transformed")) {
            try {
                successed = this.zookeeper.delete(StagePathUtils.getTransformStage(pipelineId, processId));
                if (!successed) {
                    this.processDeleteFailed();
                }
            }
            catch (ZkException e) {
                throw new ArbitrateException("Termin_process", e);
            }
        }
        return this.processDelete(data, CollectionUtils.isEmpty((Collection)currentStages), retry);
    }

    private boolean processDelete(TerminEventData data, boolean noStage, boolean retry) {
        Long pipelineId = data.getPipelineId();
        Long processId = data.getProcessId();
        boolean result = false;
        String path = StagePathUtils.getProcess(pipelineId, processId);
        byte[] bytes = null;
        try {
            bytes = (byte[])this.zookeeper.readData(path);
        }
        catch (ZkNoNodeException e) {
            return false;
        }
        ProcessNodeEventData nodeData = (ProcessNodeEventData)JsonUtils.unmarshalFromByte((byte[])bytes, ProcessNodeEventData.class);
        if (nodeData.getStatus().isUsed()) {
            if (noStage && nodeData.getMode().isZookeeper()) {
                this.processDeleteFailed();
                return this.processDelete(data, false, retry);
            }
            if (!retry) {
                result = this.createTermin(data, pipelineId, processId);
            }
        }
        try {
            result = this.zookeeper.deleteRecursive(StagePathUtils.getProcess(pipelineId, processId));
            if (!result) {
                this.doProcess(data, true);
            }
        }
        catch (ZkInterruptedException e) {
            throw e;
        }
        catch (ZkException e) {
            this.doProcess(data, true);
        }
        return result;
    }

    private boolean createTermin(TerminEventData data, Long pipelineId, Long processId) {
        String path = StagePathUtils.getTermin(pipelineId, processId);
        data.setCurrNid(ArbitrateConfigUtils.getCurrentNid());
        byte[] bytes = JsonUtils.marshalToByte((Object)data);
        try {
            this.zookeeper.create(path, (Object)bytes, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            return false;
        }
        catch (ZkException e) {
            throw new ArbitrateException("Termin_single", e);
        }
        return true;
    }

    private void processDeleteFailed() {
        try {
            Thread.sleep(500 + RandomUtils.nextInt((int)500));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

