/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin;

import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin.NormalTerminProcess;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin.TerminProcess;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.lock.DistributedLock;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTerminProcess
implements TerminProcess {
    protected static final Logger logger = LoggerFactory.getLogger(ErrorTerminProcess.class);
    protected ZkClientx zookeeper = ZooKeeperClient.getInstance();
    protected ArbitrateManageService arbitrateManageService;
    protected NormalTerminProcess normalTerminProcess;

    @Override
    public boolean process(TerminEventData data) {
        DistributedLock lock = new DistributedLock(StagePathUtils.getLoadLock(data.getPipelineId()));
        try {
            boolean locked = lock.tryLock();
            if (!locked) {
                boolean bl = false;
                return bl;
            }
            this.processChain(data);
            boolean bl = true;
            return bl;
        }
        catch (KeeperException e) {
            throw new ArbitrateException("Termin_process", e);
        }
        finally {
            try {
                lock.unlock();
            }
            catch (KeeperException keeperException) {}
        }
    }

    public void processChain(TerminEventData data) {
        Long pipelineId = data.getPipelineId();
        String processRoot = StagePathUtils.getProcessRoot(pipelineId);
        try {
            List processNodes = this.zookeeper.getChildren(processRoot);
            ArrayList<Long> processIds = new ArrayList<Long>();
            for (String process : processNodes) {
                processIds.add(StagePathUtils.getProcessId(process));
            }
            Collections.sort(processIds);
            Long processId = data.getProcessId();
            if (processId != null) {
                this.normalTerminProcess.process(data);
            }
            for (Long currProcessId : processIds) {
                if (processId != null && currProcessId <= processId) continue;
                data.setProcessId(currProcessId);
                this.processChain(data);
                break;
            }
        }
        catch (ZkException e) {
            throw new ArbitrateException("Termin_process", e);
        }
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setNormalTerminProcess(NormalTerminProcess normalTerminProcess) {
        this.normalTerminProcess = normalTerminProcess;
    }
}

