/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.monitor;

import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateLifeCycle;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StageComparator;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MonitorScheduler;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.monitor.StageListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.AsyncWatcher;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import com.alibaba.otter.shared.common.utils.zookeeper.ZooKeeperx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.commons.lang.ClassUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StageMonitor
extends ArbitrateLifeCycle
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(StageMonitor.class);
    private ExecutorService arbitrateExecutor;
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private volatile List<Long> currentProcessIds = new ArrayList<Long>();
    private volatile Map<Long, List<String>> currentStages = new ConcurrentHashMap<Long, List<String>>();
    private List<StageListener> listeners = Collections.synchronizedList(new ArrayList());
    private IZkChildListener processListener = new IZkChildListener(){

        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
            if (currentChilds != null) {
                StageMonitor.this.initStage(currentChilds);
            }
        }
    };

    public StageMonitor(Long pipelineId) {
        super(pipelineId);
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        List childs = this.zookeeper.subscribeChildChanges(path, this.processListener);
        this.initStage(childs);
        MonitorScheduler.register(this);
    }

    @Override
    public void destory() {
        super.destory();
        if (logger.isDebugEnabled()) {
            logger.debug("## destory Stage pipeline[{}]", (Object)this.getPipelineId());
        }
        this.listeners.clear();
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        this.zookeeper.unsubscribeChildChanges(path, this.processListener);
        MonitorScheduler.unRegister(this);
    }

    @Override
    public void reload() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("## reload Stage pipeline[{}]", (Object)this.getPipelineId());
            }
            this.initStage();
            for (Long processId : this.currentProcessIds) {
                this.reload(processId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadWithoutStage() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("## reload Stage pipeline[{}]", (Object)this.getPipelineId());
            }
            this.initStage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reload(Long processId) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("## reload Stage pipeline[{}] process[{}]", (Object)this.getPipelineId(), (Object)processId);
            }
            this.initProcessStage(processId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Long> getCurrentProcessIds() {
        return this.getCurrentProcessIds(false);
    }

    public List<Long> getCurrentProcessIds(boolean reload) {
        if (reload) {
            this.reloadWithoutStage();
        }
        return this.currentProcessIds;
    }

    public List<String> getCurrentStages(Long processId) {
        return this.getCurrentStages(processId, false);
    }

    public List<String> getCurrentStages(Long processId, boolean reload) {
        List<String> stages;
        if (reload) {
            this.reload(processId);
        }
        if ((stages = this.currentStages.get(processId)) == null) {
            stages = new ArrayList<String>();
        }
        return stages;
    }

    private void initStage() {
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        List currentProcesses = this.zookeeper.getChildren(path);
        this.initStage(currentProcesses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStage(List<String> currentProcesses) {
        ArrayList<Long> processIds = new ArrayList<Long>();
        for (String process : currentProcesses) {
            processIds.add(StagePathUtils.getProcessId(process));
        }
        Collections.sort(processIds);
        ArrayList<Long> needSyncProcessIds = new ArrayList<Long>();
        List<Long> list = this.currentProcessIds;
        synchronized (list) {
            for (Long processId : processIds) {
                if (this.currentProcessIds.contains(processId)) continue;
                needSyncProcessIds.add(processId);
            }
            for (Long currentProcessId : this.currentProcessIds) {
                if (processIds.contains(currentProcessId)) continue;
                this.currentStages.remove(currentProcessId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("pipeline[{}] old processIds{},current processIds{}", new Object[]{this.getPipelineId(), this.currentProcessIds, processIds});
            }
            this.currentProcessIds = processIds;
        }
        for (Long syncProcessId : needSyncProcessIds) {
            this.syncStage(syncProcessId);
        }
        if (processIds.size() > 0) {
            this.initProcessStage((Long)processIds.get(0));
        }
        this.processChanged(this.currentProcessIds);
    }

    private boolean initProcessStage(Long processId) {
        String path = null;
        try {
            path = StagePathUtils.getProcess(this.getPipelineId(), processId);
            List currentStages = this.zookeeper.getChildren(path);
            return this.initProcessStage(processId, currentStages);
        }
        catch (ZkNoNodeException e) {
            return false;
        }
        catch (ZkException e) {
            return true;
        }
    }

    private boolean initProcessStage(Long processId, List<String> currentStages) {
        Collections.sort(currentStages, new StageComparator());
        if (logger.isDebugEnabled()) {
            logger.debug("pipeline[{}] processId[{}] with stage{}", new Object[]{this.getPipelineId(), processId, currentStages});
        }
        this.currentStages.put(processId, currentStages);
        this.stageChanged(processId, currentStages);
        return currentStages.contains("transformed");
    }

    private void syncStage(final Long processId) {
        String path = null;
        try {
            path = StagePathUtils.getProcess(this.getPipelineId(), processId);
            IZkConnection connection = this.zookeeper.getConnection();
            ZooKeeper orginZk = ((ZooKeeperx)connection).getZookeeper();
            List currentStages = orginZk.getChildren(path, (Watcher)new AsyncWatcher(){

                @Override
                public void asyncProcess(WatchedEvent event) {
                    boolean dataChanged;
                    MDC.put((String)"otter", (String)String.valueOf(StageMonitor.this.getPipelineId()));
                    if (StageMonitor.this.isStop()) {
                        return;
                    }
                    if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                        StageMonitor.this.processTermined(processId);
                        return;
                    }
                    boolean bl = dataChanged = event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeChildrenChanged;
                    if (dataChanged) {
                        StageMonitor.this.syncStage(processId);
                    }
                }
            });
            Collections.sort(currentStages, new StageComparator());
            List<String> lastStages = this.currentStages.get(processId);
            if (lastStages == null || !lastStages.equals(currentStages)) {
                this.initProcessStage(processId);
            }
        }
        catch (KeeperException.NoNodeException e) {
            this.processTermined(processId);
        }
        catch (KeeperException e) {
            this.syncStage(processId);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addListener(StageListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] add listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.add(listener);
    }

    public void removeListener(StageListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] remove listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.remove(listener);
    }

    private void processChanged(final List<Long> processIds) {
        for (final StageListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"otter", (String)String.valueOf(StageMonitor.this.getPipelineId()));
                    listener.processChanged(processIds);
                }
            });
        }
    }

    private void stageChanged(final Long processId, final List<String> stages) {
        for (final StageListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"otter", (String)String.valueOf(StageMonitor.this.getPipelineId()));
                    listener.stageChannged(processId, stages);
                }
            });
        }
    }

    private void processTermined(final Long processId) {
        for (final StageListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"otter", (String)String.valueOf(StageMonitor.this.getPipelineId()));
                    listener.processTermined(processId);
                }
            });
        }
    }

    public void setArbitrateExecutor(ExecutorService arbitrateExecutor) {
        this.arbitrateExecutor = arbitrateExecutor;
    }
}

