/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.TransformArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.monitor.TransformStageListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TransformZooKeeperArbitrateEvent
implements TransformArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(TransformZooKeeperArbitrateEvent.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    @Override
    public EtlEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
        TransformStageListener transformStageListener = ArbitrateFactory.getInstance(pipelineId, TransformStageListener.class);
        Long processId = transformStageListener.waitForProcess();
        ChannelStatus status = permitMonitor.getChannelPermit();
        if (status.isStart()) {
            String path = StagePathUtils.getExtractStage(pipelineId, processId);
            try {
                byte[] data = (byte[])this.zookeeper.readData(path);
                EtlEventData eventData = (EtlEventData)JsonUtils.unmarshalFromByte((byte[])data, EtlEventData.class);
                eventData.setNextNid(ArbitrateConfigUtils.getCurrentNid());
                return eventData;
            }
            catch (ZkNoNodeException e) {
                logger.error("pipeline[{}] processId[{}] is invalid , retry again", (Object)pipelineId, (Object)processId);
                return this.await(pipelineId);
            }
            catch (ZkException e) {
                throw new ArbitrateException("transform_await", e.getMessage(), e);
            }
        }
        logger.info("pipelineId[{}] transform ignore processId[{}] by status[{}]", new Object[]{pipelineId, processId, status});
        String path = StagePathUtils.getProcess(pipelineId, processId);
        this.zookeeper.delete(path);
        return this.await(pipelineId);
    }

    @Override
    public void single(EtlEventData data) {
        Assert.notNull((Object)data);
        String path = StagePathUtils.getTransformStage(data.getPipelineId(), data.getProcessId());
        data.setCurrNid(ArbitrateConfigUtils.getCurrentNid());
        byte[] bytes = JsonUtils.marshalToByte((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        try {
            this.zookeeper.create(path, (Object)bytes, CreateMode.PERSISTENT);
        }
        catch (ZkNoNodeException e) {
            logger.warn("pipelineId[{}] transform ignore processId[{}] single by data:{}", new Object[]{data.getPipelineId(), data.getProcessId(), data});
        }
        catch (ZkNodeExistsException e) {
            logger.warn("pipelineId[{}] transform ignore processId[{}] single by data:{}", new Object[]{data.getPipelineId(), data.getProcessId(), data});
        }
        catch (ZkException e) {
            throw new ArbitrateException("transform_single", e.getMessage(), e);
        }
    }
}

