/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.ExtractArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.lb.LoadBalanceFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.monitor.ExtractStageListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExtractZooKeeperArbitrateEvent
implements ExtractArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(ExtractZooKeeperArbitrateEvent.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    @Override
    public EtlEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
        ExtractStageListener extractStageListener = ArbitrateFactory.getInstance(pipelineId, ExtractStageListener.class);
        Long processId = extractStageListener.waitForProcess();
        ChannelStatus status = permitMonitor.getChannelPermit();
        if (status.isStart()) {
            String path = StagePathUtils.getSelectStage(pipelineId, processId);
            try {
                byte[] data = (byte[])this.zookeeper.readData(path);
                EtlEventData eventData = (EtlEventData)JsonUtils.unmarshalFromByte((byte[])data, EtlEventData.class);
                Node node = LoadBalanceFactory.getNextTransformNode(pipelineId);
                if (node == null) {
                    throw new ArbitrateException("Extract_single", "no next node");
                }
                eventData.setNextNid(node.getId());
                return eventData;
            }
            catch (ZkNoNodeException e) {
                logger.error("pipeline[{}] processId[{}] is invalid , retry again", (Object)pipelineId, (Object)processId);
                return this.await(pipelineId);
            }
            catch (ZkException e) {
                throw new ArbitrateException("Extract_await", e.getMessage(), e);
            }
        }
        logger.warn("pipelineId[{}] extract ignore processId[{}] by status[{}]", new Object[]{pipelineId, processId, status});
        String path = StagePathUtils.getProcess(pipelineId, processId);
        this.zookeeper.delete(path);
        return this.await(pipelineId);
    }

    @Override
    public void single(EtlEventData data) {
        Assert.notNull((Object)data);
        String path = StagePathUtils.getExtractStage(data.getPipelineId(), data.getProcessId());
        data.setCurrNid(ArbitrateConfigUtils.getCurrentNid());
        byte[] bytes = JsonUtils.marshalToByte((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        try {
            this.zookeeper.create(path, (Object)bytes, CreateMode.PERSISTENT);
        }
        catch (ZkNoNodeException e) {
            logger.warn("pipelineId[{}] extract ignore processId[{}] single by data:{}", new Object[]{data.getPipelineId(), data.getProcessId(), data});
        }
        catch (ZkNodeExistsException e) {
            logger.warn("pipelineId[{}] extract ignore processId[{}] single by data:{}", new Object[]{data.getPipelineId(), data.getProcessId(), data});
        }
        catch (ZkInterruptedException e) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("Extract_single", e.getMessage(), e);
        }
    }
}

