/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.rpc.monitor;

import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateLifeCycle;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MonitorScheduler;
import com.alibaba.otter.shared.arbitrate.impl.setl.rpc.monitor.ProcessListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.I0Itec.zkclient.IZkChildListener;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ProcessMonitor
extends ArbitrateLifeCycle
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMonitor.class);
    private ExecutorService arbitrateExecutor;
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private volatile List<Long> currentProcessIds = new ArrayList<Long>();
    private List<ProcessListener> listeners = Collections.synchronizedList(new ArrayList());
    private IZkChildListener processListener = new IZkChildListener(){

        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
            if (currentChilds != null) {
                ProcessMonitor.this.initProcess(currentChilds);
            }
        }
    };

    public ProcessMonitor(Long pipelineId) {
        super(pipelineId);
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        List childs = this.zookeeper.subscribeChildChanges(path, this.processListener);
        this.initProcess(childs);
        MonitorScheduler.register(this);
    }

    @Override
    public void reload() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("## reload Stage pipeline[{}]", (Object)this.getPipelineId());
            }
            this.initProcess();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Long> getCurrentProcessIds() {
        return this.getCurrentProcessIds(false);
    }

    public List<Long> getCurrentProcessIds(boolean reload) {
        if (reload) {
            this.reload();
        }
        return this.currentProcessIds;
    }

    @Override
    public void destory() {
        super.destory();
        if (logger.isDebugEnabled()) {
            logger.debug("## destory process pipeline[{}]", (Object)this.getPipelineId());
        }
        this.listeners.clear();
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        this.zookeeper.unsubscribeChildChanges(path, this.processListener);
        MonitorScheduler.unRegister(this);
    }

    private void initProcess() {
        String path = StagePathUtils.getProcessRoot(this.getPipelineId());
        List currentProcesses = this.zookeeper.getChildren(path);
        this.initProcess(currentProcesses);
    }

    private void initProcess(List<String> currentProcesses) {
        ArrayList<Long> processIds = new ArrayList<Long>();
        for (String process : currentProcesses) {
            processIds.add(StagePathUtils.getProcessId(process));
        }
        Collections.sort(processIds);
        if (logger.isDebugEnabled()) {
            logger.debug("pipeline[{}] old processIds{},current processIds{}", new Object[]{this.getPipelineId(), this.currentProcessIds, processIds});
        }
        this.processChanged(processIds);
        this.currentProcessIds = processIds;
    }

    public void addListener(ProcessListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] add listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.add(listener);
    }

    public void removeListener(ProcessListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] remove listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.remove(listener);
    }

    private void processChanged(final List<Long> processIds) {
        for (final ProcessListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"otter", (String)String.valueOf(ProcessMonitor.this.getPipelineId()));
                    listener.processChanged(processIds);
                }
            });
        }
    }

    public void setArbitrateExecutor(ExecutorService arbitrateExecutor) {
        this.arbitrateExecutor = arbitrateExecutor;
    }
}

