/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.rpc;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.TransformArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.rpc.RpcStageController;
import com.alibaba.otter.shared.arbitrate.impl.setl.rpc.RpcStageEventDispatcher;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TransformRpcArbitrateEvent
implements TransformArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(TransformRpcArbitrateEvent.class);
    private RpcStageEventDispatcher rpcStageEventDispatcher;

    @Override
    public EtlEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
        RpcStageController stageController = ArbitrateFactory.getInstance(pipelineId, RpcStageController.class);
        Long processId = stageController.waitForProcess(StageType.TRANSFORM);
        ChannelStatus status = permitMonitor.getChannelPermit();
        if (status.isStart() || status.isPause()) {
            EtlEventData eventData = stageController.getLastData(processId);
            eventData.setNextNid(ArbitrateConfigUtils.getCurrentNid());
            return eventData;
        }
        logger.warn("pipelineId[{}] transform ignore processId[{}] by status[{}]", new Object[]{pipelineId, processId, status});
        return this.await(pipelineId);
    }

    @Override
    public void single(EtlEventData data) {
        Assert.notNull((Object)data);
        this.rpcStageEventDispatcher.single(StageType.TRANSFORM, data);
    }

    public void setRpcStageEventDispatcher(RpcStageEventDispatcher rpcStageEventDispatcher) {
        this.rpcStageEventDispatcher = rpcStageEventDispatcher;
    }
}

