/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.rpc;

import com.alibaba.otter.shared.arbitrate.impl.communication.ArbitrateCommmunicationClient;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.rpc.RpcStageController;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.arbitrate.ArbitrateEventType;
import com.alibaba.otter.shared.communication.model.arbitrate.StageSingleEvent;
import org.springframework.util.Assert;

public class RpcStageEventDispatcher {
    private ArbitrateCommmunicationClient arbitrateCommmunicationClient;

    public RpcStageEventDispatcher() {
        CommunicationRegistry.regist((EventType)ArbitrateEventType.stageSingle, (Object)this);
    }

    protected boolean onStageSingle(StageSingleEvent event) {
        Assert.notNull((Object)event.getPipelineId());
        RpcStageController controller = ArbitrateFactory.getInstance(event.getPipelineId(), RpcStageController.class);
        return controller.single(event.getStage(), (EtlEventData)event.getData());
    }

    public boolean single(StageType stage, EtlEventData eventData) {
        Assert.notNull((Object)eventData);
        eventData.setCurrNid(ArbitrateConfigUtils.getCurrentNid());
        StageSingleEvent event = new StageSingleEvent((EventType)ArbitrateEventType.stageSingle);
        event.setPipelineId(eventData.getPipelineId());
        event.setStage(stage);
        event.setData((Object)eventData);
        if (this.isLocal(eventData.getNextNid())) {
            return this.onStageSingle(event);
        }
        return (Boolean)this.arbitrateCommmunicationClient.call(eventData.getNextNid(), (Event)event);
    }

    private boolean isLocal(Long targetNodeId) {
        return ArbitrateConfigUtils.getCurrentNid().equals(targetNodeId);
    }

    public void setArbitrateCommmunicationClient(ArbitrateCommmunicationClient arbitrateCommmunicationClient) {
        this.arbitrateCommmunicationClient = arbitrateCommmunicationClient;
    }
}

