/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.monitor;

import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateLifeCycle;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.TerminProcessQueue;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MonitorScheduler;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.IZkChildListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TerminMonitor
extends ArbitrateLifeCycle
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(TerminMonitor.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private TerminProcessQueue waitProcessIds = new TerminProcessQueue();
    private IZkChildListener childListener = new IZkChildListener(){

        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
            if (currentChilds != null) {
                TerminMonitor.this.initTermin(currentChilds);
            }
        }
    };

    public TerminMonitor(Long pipelineId) {
        super(pipelineId);
        String path = StagePathUtils.getTerminRoot(this.getPipelineId());
        List childs = this.zookeeper.subscribeChildChanges(path, this.childListener);
        this.initTermin(childs);
        MonitorScheduler.register(this);
    }

    @Override
    public void reload() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("## reload termin pipeline[{}]", (Object)this.getPipelineId());
            }
            this.initTermin();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void destory() {
        super.destory();
        if (logger.isDebugEnabled()) {
            logger.debug("## destory termin pipeline[{}]", (Object)this.getPipelineId());
        }
        String path = StagePathUtils.getTerminRoot(this.getPipelineId());
        this.zookeeper.unsubscribeChildChanges(path, this.childListener);
        MonitorScheduler.unRegister(this);
        this.waitProcessIds.clear();
    }

    public Long waitForProcess() throws InterruptedException {
        Long processId = this.waitProcessIds.peek();
        if (logger.isDebugEnabled()) {
            logger.debug("## {} get termin id [{}]", (Object)this.getPipelineId(), (Object)processId);
        }
        return processId;
    }

    public int size() {
        return this.waitProcessIds.size();
    }

    public boolean ack(Long processId) {
        boolean result = this.waitProcessIds.ack();
        if (logger.isDebugEnabled()) {
            logger.debug("## {} ack termin id [{}]", (Object)this.getPipelineId(), (Object)processId);
        }
        return result;
    }

    private void initTermin() {
        String path = StagePathUtils.getTerminRoot(this.getPipelineId());
        List termins = this.zookeeper.getChildren(path);
        this.initTermin(termins);
    }

    private synchronized void initTermin(List<String> termins) {
        if (CollectionUtils.isEmpty(termins)) {
            return;
        }
        ArrayList<Long> processIds = new ArrayList<Long>(termins.size());
        for (String termin : termins) {
            processIds.add(StagePathUtils.getProcessId(termin));
        }
        Collections.sort(processIds);
        for (Long processId : processIds) {
            boolean successed = this.waitProcessIds.offer(processId);
            if (!successed || !logger.isDebugEnabled()) continue;
            logger.debug("## {} add termin id [{}]", (Object)this.getPipelineId(), (Object)processId);
        }
    }
}

