/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.monitor;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateLifeCycle;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MonitorScheduler;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.listener.PermitListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.MainStemEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.lock.BooleanMutex;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PermitMonitor
extends ArbitrateLifeCycle
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(PermitMonitor.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private ChannelStatus channelStatus = ChannelStatus.STOP;
    private MainStemEventData.Status mainStemStatus = MainStemEventData.Status.TAKEING;
    private MainStemEventData.Status oppositeMainStemStatus = MainStemEventData.Status.TAKEING;
    private ExecutorService arbitrateExecutor;
    private BooleanMutex permitMutex = new BooleanMutex(Boolean.valueOf(false));
    private BooleanMutex channelMutex = new BooleanMutex(Boolean.valueOf(false));
    private List<PermitListener> listeners = Collections.synchronizedList(new ArrayList());
    private volatile boolean existOpposite = ArbitrateConfigUtils.getOppositePipeline(this.getPipelineId()) != null;
    private IZkDataListener channelDataListener = new IZkDataListener(){

        public void handleDataChange(String dataPath, Object data) throws Exception {
            PermitMonitor.this.initChannelStatus((byte[])data);
        }

        public void handleDataDeleted(String dataPath) throws Exception {
            PermitMonitor.this.channelStatus = ChannelStatus.STOP;
            PermitMonitor.this.permitSem();
        }
    };
    private IZkDataListener mainstemDataListener;
    private IZkDataListener oppositeMainstemDataListener;

    public PermitMonitor(Long pipelineId) {
        super(pipelineId);
        String path = StagePathUtils.getChannel(this.getPipelineId());
        this.zookeeper.subscribeDataChanges(path, this.channelDataListener);
        this.mainstemDataListener = new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) throws Exception {
                PermitMonitor.this.initMainStemStatus((byte[])data);
            }

            public void handleDataDeleted(String dataPath) throws Exception {
                PermitMonitor.this.mainStemStatus = MainStemEventData.Status.TAKEING;
                PermitMonitor.this.permitSem();
            }
        };
        path = StagePathUtils.getMainStem(this.getPipelineId());
        this.zookeeper.subscribeDataChanges(path, this.mainstemDataListener);
        this.initChannelStatus();
        this.initMainStemStatus();
        if (this.existOpposite) {
            this.oppositeMainstemDataListener = new IZkDataListener(){

                public void handleDataChange(String dataPath, Object data) throws Exception {
                    PermitMonitor.this.initOppositeMainStemStatus((byte[])data);
                }

                public void handleDataDeleted(String dataPath) throws Exception {
                    PermitMonitor.this.oppositeMainStemStatus = MainStemEventData.Status.TAKEING;
                    PermitMonitor.this.permitSem();
                }
            };
            path = StagePathUtils.getOppositeMainStem(this.getPipelineId());
            this.zookeeper.subscribeDataChanges(path, this.oppositeMainstemDataListener);
            this.initOppositeMainStemStatus();
        }
        MonitorScheduler.register(this);
    }

    @Override
    public void reload() {
        if (logger.isDebugEnabled()) {
            logger.debug("## reload Permit pipeline[{}]", (Object)this.getPipelineId());
        }
        try {
            this.initChannelStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.initMainStemStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean prev = this.existOpposite;
        boolean bl = this.existOpposite = ArbitrateConfigUtils.getOppositePipeline(this.getPipelineId()) != null;
        if (this.existOpposite) {
            if (!prev) {
                String path = StagePathUtils.getOppositeMainStem(this.getPipelineId());
                this.zookeeper.subscribeDataChanges(path, this.oppositeMainstemDataListener);
            }
            try {
                this.initOppositeMainStemStatus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void destory() {
        super.destory();
        if (logger.isDebugEnabled()) {
            logger.debug("## destory Permit pipeline[{}]", (Object)this.getPipelineId());
        }
        String path = StagePathUtils.getChannel(this.getPipelineId());
        this.zookeeper.unsubscribeDataChanges(path, this.channelDataListener);
        path = StagePathUtils.getMainStem(this.getPipelineId());
        this.zookeeper.unsubscribeDataChanges(path, this.mainstemDataListener);
        if (this.existOpposite) {
            path = StagePathUtils.getOppositeMainStem(this.getPipelineId());
            this.zookeeper.unsubscribeDataChanges(path, this.oppositeMainstemDataListener);
        }
        MonitorScheduler.unRegister(this);
    }

    public boolean isPermit() {
        return this.isPermit(false);
    }

    public boolean isPermit(boolean reload) {
        boolean result;
        if (reload) {
            this.reload();
        }
        boolean bl = result = this.channelStatus.isStart() && this.mainStemStatus.isOverTake();
        if (this.existOpposite) {
            result &= this.oppositeMainStemStatus.isOverTake();
        }
        return result;
    }

    public ChannelStatus getChannelPermit() {
        return this.getChannelPermit(false);
    }

    public MainStemEventData.Status getMainStemPermit() {
        return this.getMainStemPermit(false);
    }

    public ChannelStatus getChannelPermit(boolean reload) {
        if (reload) {
            this.initChannelStatus();
        }
        return this.channelStatus;
    }

    public MainStemEventData.Status getMainStemPermit(boolean reload) {
        if (reload) {
            this.initMainStemStatus();
        }
        return this.mainStemStatus;
    }

    public void waitForPermit() throws InterruptedException {
        this.permitMutex.get();
    }

    public void waitForChannelPermit() throws InterruptedException {
        this.channelMutex.get();
    }

    private void initChannelStatus() {
        String path = null;
        try {
            path = StagePathUtils.getChannel(this.getPipelineId());
            byte[] bytes = (byte[])this.zookeeper.readData(path);
            this.initChannelStatus(bytes);
        }
        catch (ZkNoNodeException e) {
            this.channelStatus = ChannelStatus.STOP;
            this.permitSem();
        }
        catch (ZkException e) {
            logger.error(path, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChannelStatus(byte[] bytes) {
        ChannelStatus newChannelStatus = (ChannelStatus)JsonUtils.unmarshalFromByte((byte[])bytes, ChannelStatus.class);
        if (logger.isDebugEnabled()) {
            logger.debug("pipeline[{}] newChannelStatus is [{}]", (Object)this.getPipelineId(), (Object)newChannelStatus);
        }
        PermitMonitor permitMonitor = this;
        synchronized (permitMonitor) {
            if (!newChannelStatus.equals((Object)this.channelStatus)) {
                this.channelStatus = newChannelStatus;
                this.permitSem();
            }
        }
    }

    private void initMainStemStatus() {
        String path = null;
        try {
            path = StagePathUtils.getMainStem(this.getPipelineId());
            byte[] bytes = (byte[])this.zookeeper.readData(path);
            this.initMainStemStatus(bytes);
        }
        catch (ZkNoNodeException e) {
            this.mainStemStatus = MainStemEventData.Status.TAKEING;
            this.permitSem();
        }
        catch (ZkException e) {
            logger.error(path, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMainStemStatus(byte[] bytes) {
        MainStemEventData eventData = (MainStemEventData)JsonUtils.unmarshalFromByte((byte[])bytes, MainStemEventData.class);
        MainStemEventData.Status newStatus = eventData.getStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("pipeline[{}] new mainStemStatus is [{}]", (Object)this.getPipelineId(), (Object)newStatus);
        }
        PermitMonitor permitMonitor = this;
        synchronized (permitMonitor) {
            if (!this.mainStemStatus.equals((Object)newStatus)) {
                this.mainStemStatus = newStatus;
                this.permitSem();
            }
        }
    }

    private void initOppositeMainStemStatus() {
        String path = null;
        try {
            path = StagePathUtils.getOppositeMainStem(this.getPipelineId());
            byte[] bytes = (byte[])this.zookeeper.readData(path);
            this.initOppositeMainStemStatus(bytes);
        }
        catch (ZkNoNodeException e) {
            this.oppositeMainStemStatus = MainStemEventData.Status.TAKEING;
            this.permitSem();
        }
        catch (ZkException e) {
            logger.error(path, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOppositeMainStemStatus(byte[] bytes) {
        MainStemEventData eventData = (MainStemEventData)JsonUtils.unmarshalFromByte((byte[])bytes, MainStemEventData.class);
        MainStemEventData.Status newStatus = eventData.getStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("pipeline[{}] new oppositeMainStemStatus is [{}]", (Object)this.getPipelineId(), (Object)newStatus);
        }
        PermitMonitor permitMonitor = this;
        synchronized (permitMonitor) {
            if (!this.oppositeMainStemStatus.equals((Object)newStatus)) {
                this.oppositeMainStemStatus = newStatus;
                this.permitSem();
            }
        }
    }

    private void permitSem() {
        if (this.channelStatus.isStart()) {
            this.channelMutex.set(Boolean.valueOf(true));
            logger.debug("channel status is ok!");
        } else {
            this.channelMutex.set(Boolean.valueOf(false));
            logger.debug("channel status is fail!");
        }
        boolean permit = this.isPermit(false);
        if (!permit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Permit is fail!");
            }
            this.permitMutex.set(Boolean.valueOf(false));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Permit is Ok!");
            }
            this.permitMutex.set(Boolean.valueOf(true));
        }
        this.processChanged(permit);
    }

    public void addListener(PermitListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] add listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.add(listener);
    }

    public void removeListener(PermitListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] remove listener [{}]", (Object)this.getPipelineId(), (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.remove(listener);
    }

    private void processChanged(final boolean isPermit) {
        for (final PermitListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"otter", (String)String.valueOf(PermitMonitor.this.getPipelineId()));
                    listener.processChanged(isPermit);
                }
            });
        }
    }

    public void setArbitrateExecutor(ExecutorService arbitrateExecutor) {
        this.arbitrateExecutor = arbitrateExecutor;
    }
}

