/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.monitor;

import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MonitorScheduler;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.listener.NodeListener;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMonitor
implements Monitor {
    private static final Logger logger = LoggerFactory.getLogger(NodeMonitor.class);
    private ExecutorService arbitrateExecutor;
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();
    private List<NodeListener> listeners = Collections.synchronizedList(new ArrayList());
    private volatile List<Long> aliveNodes = new ArrayList<Long>();
    private IZkChildListener childListener = new IZkChildListener(){

        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
            if (currentChilds != null) {
                NodeMonitor.this.initNodes(currentChilds);
            }
        }
    };

    public NodeMonitor() {
        List childs = this.zookeeper.subscribeChildChanges("/otter/node", this.childListener);
        if (childs == null) {
            try {
                this.zookeeper.createPersistent("/otter/node", true);
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                // empty catch block
            }
            childs = this.zookeeper.getChildren("/otter/node");
        }
        this.initNodes(childs);
        MonitorScheduler.register(this);
    }

    @Override
    public void reload() {
        try {
            this.initNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destory() {
        this.listeners.clear();
        this.zookeeper.unsubscribeChildChanges("/otter/node", this.childListener);
        MonitorScheduler.unRegister(this);
    }

    public List<Long> getAliveNodes(boolean reload) {
        if (reload) {
            this.initNodes();
        }
        return new ArrayList<Long>(this.aliveNodes);
    }

    public List<Long> getAliveNodes() {
        return this.getAliveNodes(false);
    }

    private void initNodes() {
        List nodes = this.zookeeper.getChildren("/otter/node");
        this.initNodes(nodes);
    }

    private synchronized void initNodes(List<String> nodes) {
        ArrayList<Long> nids = new ArrayList<Long>();
        for (String node : nodes) {
            if (!StringUtils.isNumeric((String)node)) continue;
            nids.add(Long.valueOf(node));
        }
        Collections.sort(nids);
        if (!this.aliveNodes.equals(nids)) {
            if (logger.isDebugEnabled()) {
                logger.debug("old aliveNodes{} ,current aliveNodes{}", new Object[]{this.aliveNodes, nids});
            }
            this.aliveNodes = nids;
            this.processChanged(nids);
        }
    }

    public void addListener(NodeListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## pipeline[{}] add listener [{}]", (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.add(listener);
    }

    public void removeListener(NodeListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("## remove listener [{}]", (Object)ClassUtils.getShortClassName(listener.getClass()));
        }
        this.listeners.remove(listener);
    }

    private void processChanged(final List<Long> nodes) {
        for (final NodeListener listener : this.listeners) {
            this.arbitrateExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.processChanged(nodes);
                }
            });
        }
    }

    public void setArbitrateExecutor(ExecutorService arbitrateExecutor) {
        this.arbitrateExecutor = arbitrateExecutor;
    }
}

