/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.monitor;

import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.Monitor;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MonitorScheduler {
    private static final Long DEFAULT_PERIOD = 60000L;
    private static final int DEFAULT_POOL = 10;
    private static ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new NamedThreadFactory("Arbitrate-Monitor"), new ThreadPoolExecutor.CallerRunsPolicy());
    private static Map<Monitor, ScheduledFuture> register = new ConcurrentHashMap<Monitor, ScheduledFuture>(10);

    public static void register(Monitor monitor) {
        MonitorScheduler.register(monitor, DEFAULT_PERIOD);
    }

    public static void register(Monitor monitor, Long delay) {
        MonitorScheduler.register(monitor, delay, DEFAULT_PERIOD);
    }

    public static void register(final Monitor monitor, Long delay, Long period) {
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                monitor.reload();
            }
        }, delay, period, TimeUnit.MILLISECONDS);
        register.put(monitor, future);
    }

    public static void unRegister(Monitor monitor) {
        ScheduledFuture future = register.remove(monitor);
        if (future != null) {
            future.cancel(true);
        }
    }
}

