/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.memory;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.communication.ArbitrateCommmunicationClient;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.manage.ChannelArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.TerminArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.memory.MemoryStageController;
import com.alibaba.otter.shared.arbitrate.impl.setl.zookeeper.termin.WarningTerminProcess;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.model.arbitrate.StopChannelEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TerminMemoryArbitrateEvent
implements TerminArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(TerminMemoryArbitrateEvent.class);
    private ArbitrateCommmunicationClient arbitrateCommmunicationClient;
    private WarningTerminProcess warningTerminProcess;
    private ChannelArbitrateEvent channelEvent;

    @Override
    public TerminEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        MemoryStageController stageController = ArbitrateFactory.getInstance(pipelineId, MemoryStageController.class);
        TerminEventData eventData = stageController.waitTermin();
        if (logger.isDebugEnabled()) {
            logger.debug("## await pipeline[{}] processId[{}] is termin", (Object)pipelineId, (Object)eventData.getProcessId());
        }
        return eventData;
    }

    @Override
    public void exhaust(Long pipelineId) {
        Assert.notNull((Object)pipelineId);
        MemoryStageController stageController = ArbitrateFactory.getInstance(pipelineId, MemoryStageController.class);
        int size = stageController.sizeTermin();
        try {
            for (int i = 0; i < size; ++i) {
                TerminEventData data = stageController.waitTermin();
                this.ack(data);
            }
        }
        catch (InterruptedException e) {
            throw new ArbitrateException(e);
        }
    }

    @Override
    public void single(TerminEventData data) {
        TerminEventData.TerminType type = data.getType();
        MemoryStageController stageController = ArbitrateFactory.getInstance(data.getPipelineId(), MemoryStageController.class);
        if (type.isNormal()) {
            Assert.notNull((Object)data.getProcessId());
            stageController.offerTermin(data);
        } else if (type.isWarning()) {
            this.warningTerminProcess.process(data);
        } else {
            boolean restarted;
            Channel channel = ArbitrateConfigUtils.getChannel(data.getPipelineId());
            if (data.getType().isRollback()) {
                boolean paused = this.channelEvent.pause(channel.getId(), false);
                if (paused) {
                    this.warningTerminProcess.process(data);
                }
            } else if (data.getType().isShutdown()) {
                boolean shutdowned = this.channelEvent.stop(channel.getId(), false);
                if (shutdowned) {
                    this.warningTerminProcess.process(data);
                }
                StopChannelEvent event = new StopChannelEvent();
                event.setChannelId(channel.getId());
                this.arbitrateCommmunicationClient.callManager((Event)event);
            } else if (data.getType().isRestart() && (restarted = this.channelEvent.restart(channel.getId(), false))) {
                this.warningTerminProcess.process(data);
            }
            stageController.termin(data.getType());
        }
    }

    @Override
    public void ack(TerminEventData data) {
        MemoryStageController stageController = ArbitrateFactory.getInstance(data.getPipelineId(), MemoryStageController.class);
        stageController.ackTermin(data);
    }

    @Override
    public int size(Long pipelineId) {
        MemoryStageController stageController = ArbitrateFactory.getInstance(pipelineId, MemoryStageController.class);
        return stageController.sizeTermin();
    }

    public void setArbitrateCommmunicationClient(ArbitrateCommmunicationClient arbitrateCommmunicationClient) {
        this.arbitrateCommmunicationClient = arbitrateCommmunicationClient;
    }

    public void setWarningTerminProcess(WarningTerminProcess warningTerminProcess) {
        this.warningTerminProcess = warningTerminProcess;
    }

    public void setChannelEvent(ChannelArbitrateEvent channelEvent) {
        this.channelEvent = channelEvent;
    }
}

