/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.memory;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.LoadArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.memory.MemoryStageController;
import com.alibaba.otter.shared.arbitrate.impl.setl.memory.TerminMemoryArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LoadMemoryArbitrateEvent
implements LoadArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(LoadMemoryArbitrateEvent.class);
    private TerminMemoryArbitrateEvent terminEvent;

    @Override
    public EtlEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
        MemoryStageController stageController = ArbitrateFactory.getInstance(pipelineId, MemoryStageController.class);
        Long processId = stageController.waitForProcess(StageType.LOAD);
        ChannelStatus status = permitMonitor.getChannelPermit();
        if (status.isStart()) {
            return stageController.getLastData(processId);
        }
        logger.warn("pipelineId[{}] load ignore processId[{}] by status[{}],rollback now", new Object[]{pipelineId, processId, status});
        stageController.termin(TerminEventData.TerminType.ROLLBACK);
        return this.await(pipelineId);
    }

    @Override
    public void single(EtlEventData data) {
        Assert.notNull((Object)data);
        data.setEndTime(new Date().getTime());
        MemoryStageController stageController = ArbitrateFactory.getInstance(data.getPipelineId(), MemoryStageController.class);
        boolean result = stageController.single(StageType.LOAD, data);
        if (result) {
            TerminEventData termin = new TerminEventData();
            termin.setPipelineId(data.getPipelineId());
            termin.setProcessId(data.getProcessId());
            termin.setStartTime(data.getStartTime());
            termin.setEndTime(data.getEndTime());
            termin.setFirstTime(data.getFirstTime());
            termin.setNumber(data.getNumber());
            termin.setBatchId(data.getBatchId());
            termin.setSize(data.getSize());
            termin.setExts(data.getExts());
            termin.setType(TerminEventData.TerminType.NORMAL);
            termin.setCode("setl");
            termin.setDesc("");
            termin.setCurrNid(ArbitrateConfigUtils.getCurrentNid());
            this.terminEvent.single(termin);
        }
    }

    public void setTerminEvent(TerminMemoryArbitrateEvent terminEvent) {
        this.terminEvent = terminEvent;
    }
}

