/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.memory;

import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.ExtractArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.memory.MemoryStageController;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.model.EtlEventData;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ExtractMemoryArbitrateEvent
implements ExtractArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(ExtractMemoryArbitrateEvent.class);

    @Override
    public EtlEventData await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
        MemoryStageController stageController = ArbitrateFactory.getInstance(pipelineId, MemoryStageController.class);
        Long processId = stageController.waitForProcess(StageType.EXTRACT);
        ChannelStatus status = permitMonitor.getChannelPermit();
        if (status.isStart()) {
            return stageController.getLastData(processId);
        }
        logger.warn("pipelineId[{}] extract ignore processId[{}] by status[{}],rollback now", new Object[]{pipelineId, processId, status});
        stageController.termin(TerminEventData.TerminType.ROLLBACK);
        return this.await(pipelineId);
    }

    @Override
    public void single(EtlEventData data) {
        Assert.notNull((Object)data);
        MemoryStageController stageController = ArbitrateFactory.getInstance(data.getPipelineId(), MemoryStageController.class);
        stageController.single(StageType.EXTRACT, data);
    }
}

