/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.lb;

import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.lb.AbstractLoadBalance;
import com.alibaba.otter.shared.arbitrate.impl.setl.lb.LoadBalance;
import com.alibaba.otter.shared.common.model.config.node.Node;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.math.RandomUtils;

public abstract class StickLoadBalance
extends AbstractLoadBalance
implements LoadBalance {
    private int stickPercent = 100;
    private long lastNid = -1L;
    private int randomThresold = 100;
    private AtomicLong stickCount = new AtomicLong(0L);

    public StickLoadBalance(Long pipelineId) {
        super(pipelineId);
    }

    @Override
    public Node next() throws InterruptedException {
        Node node2;
        List<Node> nodes = this.getAliveNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Long nid = ArbitrateConfigUtils.getCurrentNid();
        Node current = new Node();
        current.setId(nid);
        boolean existLocal = nodes.remove(current);
        if (existLocal && nodes.size() == 0) {
            return current;
        }
        if (existLocal && RandomUtils.nextInt((int)100) <= this.stickPercent) {
            return current;
        }
        for (Node node2 : nodes) {
            if (!node2.getId().equals(this.lastNid) || RandomUtils.nextInt((int)100) > this.stickPercent) continue;
            this.lastNid = node2.getId();
            long count = this.stickCount.incrementAndGet();
            if (count > (long)this.randomThresold) {
                this.lastNid = -1L;
                this.stickCount.set(0L);
            }
            return node2;
        }
        int index = RandomUtils.nextInt((int)nodes.size());
        node2 = nodes.get(index);
        this.lastNid = node2.getId();
        return node2;
    }

    public void setStickPercent(int stickPercent) {
        this.stickPercent = stickPercent;
    }

    public void setRandomThresold(int randomThresold) {
        this.randomThresold = randomThresold;
    }
}

