/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.helper;

import com.alibaba.otter.shared.arbitrate.impl.setl.helper.LRULinkedHashMap;
import java.util.PriorityQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class TerminProcessQueue {
    private PriorityQueue<Long> queue = new PriorityQueue();
    private static final Object PRESENT = new Object();
    private LRULinkedHashMap<Long, Object> history;
    private ReentrantLock lock = new ReentrantLock();
    private Condition notEmpty = this.lock.newCondition();

    public TerminProcessQueue() {
        this.history = new LRULinkedHashMap(100);
    }

    public Long peek() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.size() == 0) {
                this.notEmpty.await();
            }
            Long l = this.queue.peek();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Long processId) {
        this.lock.lock();
        try {
            if (this.contains(processId)) {
                boolean bl = false;
                return bl;
            }
            int size = this.queue.size();
            this.queue.add(processId);
            if (size == 0) {
                this.notEmpty.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean contains(Long processId) {
        return this.queue.contains(processId) || this.history.containsKey(processId);
    }

    public boolean ack() {
        this.lock.lock();
        try {
            Long result = this.queue.poll();
            if (result != null) {
                this.history.put(result, PRESENT);
            }
            boolean bl = result != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
            this.history.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

