/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.helper;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.config.ArbitrateConfigUtils;
import com.alibaba.otter.shared.arbitrate.impl.manage.helper.ManagePathUtils;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.text.MessageFormat;

public class StagePathUtils
extends ManagePathUtils {
    public static String getPipeline(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId));
    }

    public static String getOppositePipeline(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}", StagePathUtils.getChannelId(pipelineId), StagePathUtils.getOppositePipelineId(pipelineId));
    }

    public static String getChannel(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}", StagePathUtils.getChannelId(pipelineId));
    }

    public static String getRemedyRoot(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/remedy", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId));
    }

    public static String getProcessRoot(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId));
    }

    public static String getProcess(Long pipelineId, Long processId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process/{2}", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId), StagePathUtils.getProcessNode(processId));
    }

    public static String getTerminRoot(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/termin", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId));
    }

    public static String getTermin(Long pipelineId, Long processId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/termin/{2}", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId), StagePathUtils.getProcessNode(processId));
    }

    public static String getProcess(Long pipelineId, String processNode) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process/{2}", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId), processNode);
    }

    public static String getMainStem(Long pipelineId) {
        return StagePathUtils.getPipeline(pipelineId) + "/" + "mainstem";
    }

    public static String getOppositeMainStem(Long pipelineId) {
        return StagePathUtils.getOppositePipeline(pipelineId) + "/" + "mainstem";
    }

    public static String getLockRoot(Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/lock", StagePathUtils.getChannelId(pipelineId), String.valueOf(pipelineId));
    }

    public static String getLoadLock(Long pipelineId) {
        return StagePathUtils.getLockRoot(pipelineId) + "/" + "load";
    }

    public static String getSelectStage(Long pipelineId, Long processId) {
        return StagePathUtils.getProcess(pipelineId, processId) + "/" + "selected";
    }

    public static String getExtractStage(Long pipelineId, Long processId) {
        return StagePathUtils.getProcess(pipelineId, processId) + "/" + "extracted";
    }

    public static String getTransformStage(Long pipelineId, Long processId) {
        return StagePathUtils.getProcess(pipelineId, processId) + "/" + "transformed";
    }

    private static String getChannelId(Long pipelineId) {
        Channel channel = ArbitrateConfigUtils.getChannel(pipelineId);
        return String.valueOf(channel.getId());
    }

    private static String getOppositePipelineId(Long pipelineId) {
        Pipeline pipeline = ArbitrateConfigUtils.getOppositePipeline(pipelineId);
        if (pipeline != null) {
            Long id = pipeline.getId();
            return String.valueOf(id);
        }
        throw new ArbitrateException("pipeline[" + pipelineId + "] has not opposite pipeline!");
    }
}

