/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl.helper;

import com.alibaba.otter.shared.arbitrate.impl.setl.helper.LRULinkedHashMap;
import java.util.PriorityQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ReplyProcessQueue {
    private static final Object PRESENT = new Object();
    private LRULinkedHashMap<Long, Object> history;
    private PriorityQueue<Long> tables = new PriorityQueue();
    private ReentrantLock lock = new ReentrantLock();
    private Condition notEmpty = this.lock.newCondition();

    public ReplyProcessQueue(int historySize) {
        this.history = new LRULinkedHashMap(historySize);
    }

    public Long take() throws InterruptedException {
        try {
            this.lock.lockInterruptibly();
            Long result = null;
            do {
                if (this.tables.size() != 0) continue;
                this.notEmpty.await();
            } while ((result = this.tables.poll()) == null);
            this.history.put(result, PRESENT);
            Long l = result;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Long processId) {
        this.lock.lock();
        try {
            if (this.contains(processId)) {
                boolean bl = false;
                return bl;
            }
            int size = this.tables.size();
            this.tables.add(processId);
            if (size == 0) {
                this.notEmpty.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Long processId) {
        this.lock.lock();
        try {
            boolean result = this.tables.remove(processId);
            if (result) {
                this.history.put(processId, PRESENT);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.tables.clear();
            this.history.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean contains(Long processId) {
        return this.tables.contains(processId) || this.history.containsKey(processId);
    }

    public Object[] toArray() {
        return this.tables.toArray();
    }

    public int size() {
        return this.tables.size();
    }
}

