/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl;

import com.alibaba.otter.shared.arbitrate.exception.ArbitrateException;
import com.alibaba.otter.shared.arbitrate.impl.ArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.RemedyIndexComparator;
import com.alibaba.otter.shared.arbitrate.impl.setl.helper.StagePathUtils;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.impl.zookeeper.ZooKeeperClient;
import com.alibaba.otter.shared.arbitrate.model.RemedyIndexEventData;
import com.alibaba.otter.shared.arbitrate.model.SyncStatusEventData;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.common.utils.zookeeper.ZkClientx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ToolArbitrateEvent
implements ArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(ToolArbitrateEvent.class);
    private ZkClientx zookeeper = ZooKeeperClient.getInstance();

    public void waitForPermit(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        permitMonitor.waitForPermit();
    }

    public SyncStatusEventData fetch(Long pipelineId) {
        String path = StagePathUtils.getPipeline(pipelineId);
        try {
            byte[] bytes = (byte[])this.zookeeper.readData(path);
            if (bytes == null || bytes.length == 0) {
                SyncStatusEventData evnetData = new SyncStatusEventData();
                evnetData.setPipelineId(pipelineId);
                return evnetData;
            }
            return (SyncStatusEventData)JsonUtils.unmarshalFromByte((byte[])bytes, SyncStatusEventData.class);
        }
        catch (ZkException e) {
            throw new ArbitrateException("fetch_SyncStatus", pipelineId.toString(), e);
        }
    }

    public void single(SyncStatusEventData syncStatus) {
        String path = StagePathUtils.getPipeline(syncStatus.getPipelineId());
        try {
            byte[] bytes = JsonUtils.marshalToByte((Object)syncStatus);
            this.zookeeper.writeData(path, (Object)bytes);
            logger.info("## single status : " + syncStatus);
        }
        catch (ZkException e) {
            throw new ArbitrateException("single_SyncStatus", syncStatus.getPipelineId().toString(), e);
        }
    }

    public void addRemedyIndex(RemedyIndexEventData data) {
        String path = StagePathUtils.getRemedyRoot(data.getPipelineId());
        try {
            this.zookeeper.create(path + "/" + RemedyIndexEventData.formatNodeName(data), (Object)new byte[0], CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("addRemedyIndex", data.getPipelineId().toString(), e);
        }
    }

    public void removeRemedyIndex(RemedyIndexEventData data) {
        String path = StagePathUtils.getRemedyRoot(data.getPipelineId());
        try {
            this.zookeeper.delete(path + "/" + RemedyIndexEventData.formatNodeName(data));
        }
        catch (ZkNoNodeException zkNoNodeException) {
        }
        catch (ZkException e) {
            throw new ArbitrateException("removeRemedyIndex", data.getPipelineId().toString(), e);
        }
    }

    public List<RemedyIndexEventData> listRemedyIndexs(Long pipelineId) {
        String path = StagePathUtils.getRemedyRoot(pipelineId);
        ArrayList<RemedyIndexEventData> datas = new ArrayList<RemedyIndexEventData>();
        try {
            List nodes = this.zookeeper.getChildren(path);
            for (String node : nodes) {
                RemedyIndexEventData data = RemedyIndexEventData.parseNodeName(node);
                data.setPipelineId(pipelineId);
                datas.add(data);
            }
        }
        catch (ZkException e) {
            throw new ArbitrateException("listRemedyIndexs", pipelineId.toString(), e);
        }
        Collections.sort(datas, new RemedyIndexComparator());
        return datas;
    }

    public void release(Long pipelineId) {
        ArbitrateFactory.destory(pipelineId);
    }

    public void release() {
        ArbitrateFactory.destory();
    }
}

