/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.setl;

import com.alibaba.otter.shared.arbitrate.impl.ArbitrateEvent;
import com.alibaba.otter.shared.arbitrate.impl.setl.ArbitrateFactory;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.MainstemMonitor;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.arbitrate.model.MainStemEventData;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MainStemArbitrateEvent
implements ArbitrateEvent {
    private static final Logger logger = LoggerFactory.getLogger(MainStemArbitrateEvent.class);

    public void await(Long pipelineId) throws InterruptedException {
        Assert.notNull((Object)pipelineId);
        PermitMonitor permitMonitor = ArbitrateFactory.getInstance(pipelineId, PermitMonitor.class);
        ChannelStatus status = permitMonitor.getChannelPermit(true);
        boolean isRuning = this.check(pipelineId);
        if (!status.isStart() && isRuning) {
            MainStemEventData data = new MainStemEventData();
            data.setPipelineId(pipelineId);
            data.setStatus(MainStemEventData.Status.TAKEING);
            this.single(data);
            permitMonitor.waitForChannelPermit();
            return;
        }
        if (status.isStart() && isRuning) {
            return;
        }
        if (!isRuning) {
            if (!status.isStart()) {
                permitMonitor.waitForChannelPermit();
            }
            MainstemMonitor mainstemMonitor = ArbitrateFactory.getInstance(pipelineId, MainstemMonitor.class);
            mainstemMonitor.waitForActive();
            status = permitMonitor.getChannelPermit(false);
            if (status.isStart()) {
                return;
            }
            logger.info("pipelineId[{}] mainstem ignore by status[{}]", new Object[]{pipelineId, status});
            this.await(pipelineId);
        }
    }

    public boolean check(Long pipelineId) {
        MainstemMonitor mainstemMonitor = ArbitrateFactory.getInstance(pipelineId, MainstemMonitor.class);
        return mainstemMonitor.check();
    }

    public void single(MainStemEventData data) {
        MainstemMonitor mainstemMonitor = ArbitrateFactory.getInstance(data.getPipelineId(), MainstemMonitor.class);
        mainstemMonitor.single(data);
    }

    public void release(Long pipelineId) {
        MainstemMonitor mainstemMonitor = ArbitrateFactory.getInstance(pipelineId, MainstemMonitor.class);
        mainstemMonitor.releaseMainstem();
    }
}

