/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.shared.arbitrate.impl.manage.helper;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class ManagePathUtils {
    public static String getRoot() {
        return "/otter";
    }

    public static String getNodeRoot() {
        return "/otter/node";
    }

    public static String getChannelRoot() {
        return "/otter/channel";
    }

    public static String getNode(Long nodeId) {
        return MessageFormat.format("/otter/node/{0}", String.valueOf(nodeId));
    }

    public static String getChannelByChannelId(Long channelId) {
        return MessageFormat.format("/otter/channel/{0}", String.valueOf(channelId));
    }

    public static String getPipeline(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}", String.valueOf(channelId), String.valueOf(pipelineId));
    }

    public static String getRemedyRoot(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/remedy", String.valueOf(channelId), String.valueOf(pipelineId));
    }

    public static String getProcessRoot(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process", String.valueOf(channelId), String.valueOf(pipelineId));
    }

    public static String getMainStem(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}", String.valueOf(channelId), String.valueOf(pipelineId)) + "/" + "mainstem";
    }

    public static String getTerminRoot(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/termin", String.valueOf(channelId), String.valueOf(pipelineId));
    }

    public static String getProcess(Long channelId, Long pipelineId, Long processId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process/{2}", String.valueOf(channelId), String.valueOf(pipelineId), ManagePathUtils.getProcessNode(processId));
    }

    public static String getProcess(Long channelId, Long pipelineId, String processNode) {
        return MessageFormat.format("/otter/channel/{0}/{1}/process/{2}", String.valueOf(channelId), String.valueOf(pipelineId), processNode);
    }

    public static String getTermin(Long channelId, Long pipelineId, Long processId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/termin/{2}", String.valueOf(channelId), String.valueOf(pipelineId), ManagePathUtils.getProcessNode(processId));
    }

    public static String getLockRoot(Long channelId, Long pipelineId) {
        return MessageFormat.format("/otter/channel/{0}/{1}/lock", String.valueOf(channelId), String.valueOf(pipelineId));
    }

    public static Long getProcessId(String processNode) {
        return Long.valueOf(processNode);
    }

    public static String getProcessNode(Long processId) {
        return StringUtils.leftPad((String)String.valueOf(processId.intValue()), (int)10, (char)'0');
    }
}

